# Copyright (C) 2002 Rob Brown (bbb@cpan.org)
# Generic rpm SPEC file generator.

use strict;

my $p = $1 if $0 =~ m%([^/]*)$%;
my $output = shift or die "create what?";

### Extract $VERSION from VERSION_FROM
my $name;
my $version;
$INC{"ExtUtils/MakeMaker.pm"} = 1;
sub WriteMakefile {
  my %props = @_;
  $name = $props{NAME} || die "Makefile.PL: Missing NAME";
  if ($version = $props{VERSION}) {
    # done
  } elsif (my $version_from = $props{VERSION_FROM}) {
    $@ = "";
    $version = eval qq{
      do "$version_from";
      \$$name\::VERSION || die "$version_from: Missing VERSION";
    };
    die $@ if $@;
    if (!defined $version) {
      die "$version_from: Missing VERSION";
    }
  } else {
    die "Makefile.PL: Could not determine version!";
  }
}
do "Makefile.PL";
if ($name) {
  $name =~ s/::/-/g;
} else {
  die "Makefile.PL: Missing WriteMakefile";
}

my ($class,$subclass) = split(/\-/,$name,2);
local $/ = undef;
$_ = <DATA>;
s/\@CLASS\@/$class/g;
s/\@SUBCLASS\@/$subclass/g;
s/\@VERSION\@/$version/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC "# Automatically generated by $p\n";
print SPEC $_;
close SPEC;

__DATA__
%define class @CLASS@
%define subclass @SUBCLASS@
%define version @VERSION@
%define release 1
%define defperlver 5.6.1

# Derived values
%define real_name %{class}-%{subclass}
%define name perl-%{real_name}
%define perlver %(rpm -q perl --queryformat '%%{version}' 2> /dev/null || echo %{defperlver})

Summary:        Perl module %{class}::%{subclass}
Name:           %{name}
Version:        %{version}
Release:        %{release}
Group:          Development/Perl
License:        See documentation
Source:         http://www.cpan.org/modules/by-module/%{class}/%{real_name}-%{version}.tar.gz
Url:            http://search.cpan.org/search?dist=%{real_name}
Vendor:         Rob Brown <bbb@cpan.org>
BuildRequires:  perl
BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-%{version}-buildroot-%(id -u -n)/
Requires:       perl = %{perlver}
Provides:       %{real_name} = %{version}

%description
Perl module which implements the %{class}::%{subclass} class.

# Provide perl-specific find-{provides,requires}.
%define __find_provides /usr/lib/rpm/find-provides.perl
%define __find_requires /usr/lib/rpm/find-requires.perl

%prep
%setup -q -n %{real_name}-%{version}

%build
%{__perl} Makefile.PL
%{__make} OPTIMIZE="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall PREFIX=$RPM_BUILD_ROOT%{_prefix}
[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress
# Clean up some files we don't want/need
rm -rf `find $RPM_BUILD_ROOT -name "perllocal.pod" -o -name ".packlist" -o -name "*.bs"`
find $RPM_BUILD_ROOT%{_prefix} -type d | tac | xargs rmdir --ign

%clean
rm -rf $RPM_BUILD_ROOT
HERE=`pwd`
cd ..
rm -rf $HERE

%files
%defattr(-,root,root)
%doc CHANGES README
%{_prefix}

%changelog
* Mon May 06 2002 Rob Brown <bbb@cpan.org>
- Fix spec to actually work.
* Thu May 03 2002 Rob Brown <bbb@cpan.org>
- Compatibility changes to work with older versions of
  perl (5.005/5.6.0/5.6.1) and rpm (3.x/4.x)
* Fri Apr 19 2002 Michael McLagan <michael.mclagan@linux.org>
- Use standard naming (perl-Net-Ping)
- Reimplemented spec with my 'generic' perl module script
* Sat Apr 06 2002 Rob Brown <bbb@cpan.org>
- Hack to let this version override the default
* Thu Nov 15 2001 Rob Brown <bbb@cpan.org>
- initial creation
