package Data::Object::Autobox::Number;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->number(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Number

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Number Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Number;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Number> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Num $arg1) : NumberObject

Construct a new object.

=over 4

=item new example

  my $number = Data::Object::Autobox::Number->new(1_000);

=back

=cut
