package Moose::Exception::InvalidAttributeDefinition;

# ABSTRACT: Exceptions for invalid attribute definitions.

use Moose;
extends 'Moose::Exception';
our $VERSION = '0.05';
with 'Moose::Exception::Role::Class';

has 'attribute_name' => (
    is            => 'ro',
    isa           => 'Str',
    required      => 1,
    documentation => "The exception is thrown if an attribute name is invalid.",
);

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Moose::Exception::InvalidAttributeDefinition - Exceptions for invalid attribute definitions.

=head1 VERSION

version 0.05

=head1 AUTHOR

Curtis "Ovid" Poe <curtis.poe@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Curtis "Ovid" Poe.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
