/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.couchbase.mock.control.CommandNotFoundException;
import org.couchbase.mock.control.MockCommandDispatcher;
import org.couchbase.mock.control.handlers.MockHelpCommandHandler;
import org.couchbase.mock.httpio.HandlerUtil;

public class ControlHandler
implements HttpRequestHandler {
    private final MockCommandDispatcher dispatcher;

    public ControlHandler(MockCommandDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private static void sendHelpText(HttpResponse response, int code) throws IOException {
        HandlerUtil.makeStringResponse(response, MockHelpCommandHandler.getIndentedHelp());
        response.setStatusCode(code);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        URL url = HandlerUtil.getUrl(request);
        String path = url.getPath();
        path = path.replaceFirst("^/+", "");
        String[] components = path.split("/");
        try {
            if (components.length != 2) {
                throw new CommandNotFoundException("/mock/<COMMAND>", null);
            }
            if (components[1].equals("help")) {
                throw new WantHelpException();
            }
            JsonObject payload = HandlerUtil.getJsonQuery(url);
            String cmdStr = URLDecoder.decode(components[1], "UTF-8");
            String rStr = this.dispatcher.dispatch(cmdStr, payload).toString();
            HandlerUtil.makeJsonResponse(response, rStr);
        }
        catch (WantHelpException e) {
            ControlHandler.sendHelpText(response, 200);
        }
        catch (CommandNotFoundException e) {
            ControlHandler.sendHelpText(response, 404);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(new PrintWriter(pw));
            HandlerUtil.makeStringResponse(response, sw.toString());
            HandlerUtil.bailResponse(context, response);
            throw e;
        }
    }

    private class WantHelpException
    extends Exception {
        private WantHelpException() {
        }
    }
}

