use v6.c;

use Method::Also;

use GIO::Raw::Types;
use GIO::Raw::ProxyAddress;

use GIO::InetSocketAddress;

our subset ProxyAddressAncestry is export of Mu
  where GProxyAddress | GInetSocketAddressAncestry;

class GIO::ProxyAddress is GIO::InetSocketAddress {
  has GProxyAddress $!pa is implementor;

  submethod BUILD (:$proxy-address) {
    self.setProxyAddress($proxy-address) if $proxy-address;
  }

  method setProxyAddress(ProxyAddressAncestry $_) {
    my $to-parent;

    $!pa = do {
      when GProxyAddress {
        $to-parent = cast(GInetSocketAddress, $_);
        $_;
      }

      default {
        $to-parent = $_;
        cast(GProxyAddress, $_);
      }
    }
    self.setInetSocketAddr($to-parent);
  }

  method GIO::Raw::Definitions::GProxyAddress
    is also<GProxyAddress>
  { $!pa }

  multi method new (ProxyAddressAncestry $proxy-address, :$ref = True) {
    return Nil unless $proxy-address;

    my $o = self.bless( :$proxy-address );
    $o.ref if $ref;
    $o;
  }
  multi method new (
    GInetAddress() $inetaddr,
    Int()          $port,
    Str()          $protocol,
    Str()          $dest_hostname,
    Int()          $dest_port,
    Str()          $username,
    Str()          $password
  ) {
    my guint16 ($p, $dp) = ($port, $dest_port);
    my $proxy-address    = g_proxy_address_new(
      $inetaddr,
      $p,
      $protocol,
      $dest_hostname,
      $dp,
      $username,
      $password
    );

    $proxy-address ?? self.bless( :$proxy-address ) !! Nil;
  }

  method get_destination_hostname
    is also<
      get-destination-hostname
      destination_hostname
      destination-hostname
      dest_host
      dest-host
    >
  {
    g_proxy_address_get_destination_hostname($!pa);
  }

  method get_destination_port
    is also<
      get-destination-port
      destination_port
      destination-port
      dest_port
      dest-port
    >
  {
    g_proxy_address_get_destination_port($!pa);
  }

  method get_destination_protocol
    is also<
      get-destination-protocol
      destination_protocol
      destination-protocol
      dest_proto
      dest-proto
    >
  {
    g_proxy_address_get_destination_protocol($!pa);
  }

  method get_password
    is also<
      get-password
      password
      pass
    >
  {
    g_proxy_address_get_password($!pa);
  }

  method get_protocol
    is also<
      get-protocol
      protocol
      proto
    >
  {
    g_proxy_address_get_protocol($!pa);
  }

  method get_type is also<get-type> {
    state ($n, $t);

    unstable_get_type( self.^name, &g_proxy_address_get_type, $n, $t );
  }

  method get_uri
    is also<
      get-uri
      uri
    >
  {
    g_proxy_address_get_uri($!pa);
  }

  method get_username
    is also<
      get-username
      username
      user
    >
  {
    g_proxy_address_get_username($!pa);
  }

}
