# Generated by default/object.tt
package Paws::WorkSpaces::UserStorage;
  use Moose;
  has Capacity => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkSpaces::UserStorage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkSpaces::UserStorage object:

  $service_obj->Method(Att1 => { Capacity => $value, ..., Capacity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkSpaces::UserStorage object:

  $result = $service_obj->Method(...);
  $result->Att1->Capacity

=head1 DESCRIPTION

Describes the user storage for a WorkSpace bundle.

=head1 ATTRIBUTES


=head2 Capacity => Str

The size of the user storage.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkSpaces>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

