# Generated by default/object.tt
package Paws::Quicksight::DataSetConfiguration;
  use Moose;
  has ColumnGroupSchemaList => (is => 'ro', isa => 'ArrayRef[Paws::Quicksight::ColumnGroupSchema]');
  has DataSetSchema => (is => 'ro', isa => 'Paws::Quicksight::DataSetSchema');
  has Placeholder => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::DataSetConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::DataSetConfiguration object:

  $service_obj->Method(Att1 => { ColumnGroupSchemaList => $value, ..., Placeholder => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::DataSetConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ColumnGroupSchemaList

=head1 DESCRIPTION

Dataset configuration.

=head1 ATTRIBUTES


=head2 ColumnGroupSchemaList => ArrayRef[L<Paws::Quicksight::ColumnGroupSchema>]

A structure containing the list of column group schemas.


=head2 DataSetSchema => L<Paws::Quicksight::DataSetSchema>

Dataset schema.


=head2 Placeholder => Str

Placeholder.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

