
package Paws::IoT::DescribeAccountAuditConfiguration;
  use Moose;

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeAccountAuditConfiguration');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/audit/configuration');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::IoT::DescribeAccountAuditConfigurationResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::DescribeAccountAuditConfiguration - Arguments for method DescribeAccountAuditConfiguration on L<Paws::IoT>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeAccountAuditConfiguration on the
L<AWS IoT|Paws::IoT> service. Use the attributes of this class
as arguments to method DescribeAccountAuditConfiguration.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeAccountAuditConfiguration.

=head1 SYNOPSIS

    my $iot = Paws->service('IoT');
    my $DescribeAccountAuditConfigurationResponse =
      $iot->DescribeAccountAuditConfiguration();

    # Results:
    my $AuditCheckConfigurations =
      $DescribeAccountAuditConfigurationResponse->AuditCheckConfigurations;
    my $AuditNotificationTargetConfigurations =
      $DescribeAccountAuditConfigurationResponse
      ->AuditNotificationTargetConfigurations;
    my $RoleArn = $DescribeAccountAuditConfigurationResponse->RoleArn;

    # Returns a L<Paws::IoT::DescribeAccountAuditConfigurationResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/iot/DescribeAccountAuditConfiguration>

=head1 ATTRIBUTES



=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeAccountAuditConfiguration in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

