
package Paws::Amplify::StartDeployment;
  use Moose;
  has AppId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'appId', required => 1);
  has BranchName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'branchName', required => 1);
  has JobId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'jobId');
  has SourceUrl => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'sourceUrl');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'StartDeployment');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/apps/{appId}/branches/{branchName}/deployments/start');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Amplify::StartDeploymentResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Amplify::StartDeployment - Arguments for method StartDeployment on L<Paws::Amplify>

=head1 DESCRIPTION

This class represents the parameters used for calling the method StartDeployment on the
L<AWS Amplify|Paws::Amplify> service. Use the attributes of this class
as arguments to method StartDeployment.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to StartDeployment.

=head1 SYNOPSIS

    my $amplify = Paws->service('Amplify');
    my $StartDeploymentResult = $amplify->StartDeployment(
      AppId      => 'MyAppId',
      BranchName => 'MyBranchName',
      JobId      => 'MyJobId',        # OPTIONAL
      SourceUrl  => 'MySourceUrl',    # OPTIONAL
    );

    # Results:
    my $JobSummary = $StartDeploymentResult->JobSummary;

    # Returns a L<Paws::Amplify::StartDeploymentResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/amplify/StartDeployment>

=head1 ATTRIBUTES


=head2 B<REQUIRED> AppId => Str

Unique Id for an Amplify App.



=head2 B<REQUIRED> BranchName => Str

Name for the branch, for the Job.



=head2 JobId => Str

The job id for this deployment, generated by create deployment request.



=head2 SourceUrl => Str

The sourceUrl for this deployment, used when calling start deployment
without create deployment. SourceUrl can be any HTTP GET url that is
public accessible and downloads a single zip.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method StartDeployment in L<Paws::Amplify>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

