/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/

/* header for irtfiles.c */

#ifndef IRTFILES_H
#define IRTFILES_H

#include "cdialect.h"
#include "irfiles.h" /* for database struct */

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

typedef boolean (boolfunc)();
typedef void (voidfunc)();
typedef long (longfunc)();

char *make_joint_word _AP((char *word1, char *word2));

typedef long (wordfunc) _AP((char *word, long char_pos,
			     long line_pos, long weight,
			     long doc_id, time_t date,
			     boolean capitalized, database* db,
			     boolean word_position, boolean word_pairs));

long map_over_words
  _AP((char* line,long document_id,long weight,long file_position_before_line,
       long* line_length,boolean* newline_terminated,database* db,
       wordfunc wordfunction, boolean word_position, boolean word_pairs));

void index_text_file _AP((char* filename,
			  boolean (*separator_function)(),
			  void (*header_function)(),
			  longfunc *date_function,
			  void (*put_together_header_function)(), 
			  char *type,
			  database* db,
			  boolean check_for_text_file,
			  boolean check_for_file_already_indexed,
			  boolean word_position, boolean word_pairs));

boolean directoryp _AP ((char *file));

boolean filep _AP((char* file));

void index_directory _AP ((char *file,
			   boolfunc *separator_function,
			   voidfunc *header_function,
			   longfunc *date_function,
			   voidfunc *finish_header_function, 
			   char *type,
			   database *db,
			   boolean check_for_text_file,
			   boolean check_for_file_already_indexed,
			   boolean word_position, boolean word_pairs));

#ifdef __cplusplus
	}
#endif /* def __cplusplus */
#endif /* ndef IRTFILES_H */

