/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/

#ifndef _H_XWAIS
#define _H_XWAIS

/* usefull definitions */

#define STRINGSIZE	256

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "xstuff.h"

#include "source.h"
#include "document.h"
#include "text.h"
#include "scrolllist.h"
#include "util.h"
#include "display.h"
#include "tcommands.h"
#include "qcommands.h"
#include "scommands.h"

#ifndef XWAIS_C
#include "wais.h"
#include "question.h"
#endif

#ifdef MAIN
#define ext
#else
#define ext extern
#endif

#define NUMQUESTS 100

#define NO_ITEM_SELECTED -1

#define NUMQLINES 3
#define NUMSLINES 3
#define NUMRLINES 6

/*	externals in xwais.c 	*/

ext struct _app_resources {
    char *questionDirectory;
    char *userSourceDirectory;
    char *commonSourceDirectory;
    char *documentDirectory;
    char *helpFile;
    char *removeSeekerCodes;
    char *rescanInterval;
    char *seedWords;
    char *initialSource;
    char *questionName;
    char *filters;
    int maximumResults;
    Boolean doSearch;
    Boolean defaultsInstalled;
    Boolean showKeys;
} app_resources;

ext XtIntervalId rescantimerid;

ext int numtosave;

ext Widget top, form; /* top level things for display */

ext Widget
  labelwindow,
  messwidget;

ext ScrollList
  questionwindow,
  sourcewindow;

ext Widget questionpopup,
  qnamewid, keywordwid, sshell;

ext Widget sourcepopup,
  snamewid, serverwid, servicewid, dbwid,
  costwid, unitwid, maintainerwid, descwid;

ext Widget savepopup, tsavepopup,
  savenamewid, tsavenamewid, savebutton, tsavebutton;

ext Widget sourcemenu, sourcebutton;

ext String questionname, config, db;

ext Display *CurDpy;

ext int NumQuestions;

ext Source the_Source;

#ifndef XWAIS_C
ext Question the_Question;
#endif

ext String Question_items[NUMQUESTS];

ext SList Sources;
ext String *Source_items;
ext int NumSources;

ext TextList allText;

ext Widget LastClicked;
ext Boolean double_click;

ext void Feep();

extern void DoQuit();

#endif
