/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/

#include "xwais.h"

Widget
MakeTextSavePopup(parent)
Widget parent;
{
  Widget shell, frame, labelwid, stringlabelwid;
  WidgetClass wclass;
  static String namestring;
  char label[1000];

  namestring = "";

  shell = XtCreatePopupShell("savepopup", transientShellWidgetClass,
			     parent, NULL, ZERO);
  frame = XtCreateManagedWidget("savepopupform", formWidgetClass,
				shell, NULL, ZERO);

  sprintf(label, "Save Document [dir: %s]", app_resources.documentDirectory);
  labelwid = MakeLabel(frame, "textsavelabel", label, NULL, NULL);

  stringlabelwid = MakeLabel(frame, "tsavenamelabel", "Filename:", labelwid, NULL);
  tsavenamewid = MakeStringBox(frame, "tsavename", namestring, labelwid, stringlabelwid);

  tsavebutton = MakeCommandButton(frame, "tsavedone", NULL, stringlabelwid, NULL, NULL);
  MakeCommandButton(frame, "savecancel", DontTSave, stringlabelwid, tsavebutton, NULL);

  return shell;
}

Widget
MakeSavePopup(parent)
Widget parent;
{
  Widget shell, frame, labelwid, stringlabelwid;
  WidgetClass wclass;
  static String namestring;
  char label[1000];

  namestring = "";

  shell = XtCreatePopupShell("savepopup", transientShellWidgetClass,
			     parent, NULL, ZERO);
  frame = XtCreateManagedWidget("savepopupform", formWidgetClass,
				shell, NULL, ZERO);

  sprintf(label, "Save Question [dir: %s]", app_resources.questionDirectory);
  labelwid = MakeLabel(frame, "savelabel", label, NULL, NULL);

  stringlabelwid = MakeLabel(frame, "savenamelabel", "Filename:", labelwid, NULL);
  savenamewid = MakeStringBox(frame, "savename", namestring, labelwid, stringlabelwid);

  savebutton = MakeCommandButton(frame, "savedone", NULL, stringlabelwid, NULL, NULL);
  MakeCommandButton(frame, "savecancel", DontSave, stringlabelwid, savebutton, NULL);

  return shell;
}

#include "xwaisq.bit"
#include "xwaist.bit"

void SetqIcon(parent)
Widget parent;
{
  Arg args[1];
  Pixmap icon_pixmap = None;

  XtSetArg (args[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(parent, args, ONE);
  if (icon_pixmap == None) {
    XtSetArg(args[0], XtNiconPixmap, 
	     XCreateBitmapFromData(XtDisplay(parent),
				   XtScreen(parent)->root,
				   xwaisq_bits, xwaisq_width, xwaisq_height));
    XtSetValues (parent, args, ONE);
  }
}

void SettIcon(parent)
Widget parent;
{
  Arg args[1];
  Pixmap icon_pixmap = None;

  XtSetArg (args[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(parent, args, ONE);
  if (icon_pixmap == None) {
    XtSetArg(args[0], XtNiconPixmap, 
	     XCreateBitmapFromData(XtDisplay(parent),
				   XtScreen(parent)->root,
				   xwaist_bits, xwaist_width, xwaist_height));
    XtSetValues (parent, args, ONE);
  }
}

Widget
MakeQuestionPane(parent, question)
Widget parent;
Question question;
{
  Widget frame, stringlabelwid, button, view;
  static String
    name = "";
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, question->name); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, question->name); num_args++;
  question->window->shell = parent;
  frame =
    XtCreateManagedWidget("questionpopupform", formWidgetClass,
			  question->window->shell, NULL, ZERO);

  SetqIcon(question->window->shell);

  stringlabelwid =
    MakeLabel(frame, "keywordlabel", "Tell me about:", NULL, NULL);
  question->window->keywordwid =
    MakeStringBox(frame, "keywords", "", stringlabelwid, NULL);

  button = MakeCommandButton(frame, "wsearch", DoSearch,
			     stringlabelwid, question->window->keywordwid, NULL);
  stringlabelwid =
    MakeLabel(frame, "qsourcelabel", "In Sources:",
	      NULL, NULL);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++; */
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("sview", viewportWidgetClass,
				frame, arglist, num_args);

  question->window->Sources = (ScrollList) s_malloc(sizeof(_ScrollList));
  question->window->Sources->offset = 0;

  question->window->Sources->ListWidget =
    MakeListWidget(view, "questionsource", question->Source_Items,
		   NULL, NULL);

  stringlabelwid =
    MakeLabel(frame, "qdoclabel",    "Similar to:", question->window->keywordwid, NULL, NULL);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;*/
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("dview", viewportWidgetClass,
				frame, arglist, num_args);

  question->window->RelevantDocuments = (ScrollList) s_malloc(sizeof(_ScrollList));
  question->window->RelevantDocuments->offset = 0;

  question->window->RelevantDocuments->ListWidget = 
    MakeListWidget(view, "questiondoc", question->Relevant_Items,
		   NULL, NULL);

  button =
    MakeCommandButton(frame, "qaddsource", PopupSourceMenu,
		      view, NULL, NULL);
  button =
    MakeCommandButton(frame, "qdeletesource", DeleteQuestionSource,
		      view, button, NULL);
  button =
    MakeCommandButton(frame, "qadddoc", AddResponseToQuestion,
		      view, button, NULL);
  button =
    MakeCommandButton(frame, "qdeletedoc", DeleteQuestionDoc,
		      view, button, NULL);

  button =
    MakeCommandButton(frame, "help", XwaisHelp,
		      view, button, NULL);
  button =
    MakeCommandButton(frame, "qdone", CloseQuestionEdit,
		      view, button, NULL);

  stringlabelwid =
    MakeLabel(frame, "qreslabel", "Resulting\ndocuments:",
	      NULL, NULL);

  button = MakeCommandButton(frame, "view", ViewResponse,
			     stringlabelwid, NULL, NULL);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;*/
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("rview", viewportWidgetClass,
				frame, arglist, num_args);

  question->window->ResultDocuments = (ScrollList) s_malloc(sizeof(_ScrollList));
  question->window->ResultDocuments->offset = 0;

  question->window->ResultDocuments->ListWidget = 
    MakeListWidget(view, "questionresults", question->Result_Items,
		   NULL, NULL);

  XtAddCallback(question->window->ResultDocuments->ListWidget,
		XtNcallback,
		(XtCallbackProc)ViewResponse, NULL );

  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextEdit); num_args++;
  XtSetArg(arglist[num_args], XtNsensitive, False); num_args++;

  stringlabelwid =
    MakeLabel(frame, "statuslabel", "Status:",
	      NULL, NULL);

  question->window->StatusWindow =
    XtCreateManagedWidget("statusWindow", asciiTextWidgetClass,
			  frame, arglist, num_args);
  return(question->window->shell);
}

Widget
MakeTextPopup(parent, t, name)
Widget parent;
Textbuff t;
char *name;
{
  Widget frame, button;
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, name); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, name); num_args++;
  t->shell = XtCreatePopupShell("textpopup", applicationShellWidgetClass,
				parent, arglist, num_args);
  frame =
    XtCreateManagedWidget("questionpopupform", formWidgetClass,
			  t->shell, NULL, ZERO);

  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextRead); num_args++;
  t->textwindow =
    XtCreateManagedWidget("textWindow", asciiTextWidgetClass, frame, arglist, num_args);

  button = MakeCommandButton(frame, "addSection", addSection,
			     t->textwindow, NULL, NULL);
  button = MakeCommandButton(frame, "findKey", showKeyword,
			     t->textwindow, button, NULL);
  button = MakeCommandButton(frame, "showNext", showNext,
			     t->textwindow, button, t);
  button = MakeCommandButton(frame, "showPrevious", showPrevious,
			     t->textwindow, button, t);
  button = MakeCommandButton(frame, "filesave", SaveText,
			     t->textwindow, button, NULL);
  button = MakeCommandButton(frame, "tdone", EndText,
			     t->textwindow, button, t);

  MakeLabel(frame, "textstatuslabel", "Status:", button, NULL);
  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextEdit); num_args++;
  XtSetArg(arglist[num_args], XtNsensitive, False); num_args++;

  t->status =
    XtCreateManagedWidget("textStatus", asciiTextWidgetClass, frame, arglist, num_args);

  SettIcon(t->shell);

  XtPopup(t->shell, XtGrabNone);

  return t->textwindow;
}


QuestionWindow
MakeQuestionForm(question)
Question question;
{
  Widget frame, labelwid, stringlabelwid, button;
  WidgetClass wclass;
  static String
    name = "";
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};
  int n;
  float shown;

  QuestionWindow result;

  if((result = (QuestionWindow) s_malloc(sizeof(_QuestionWindow))) == NULL) {
    XwaisPrintf("Unable to allocate space for new window.\n");
    return(NULL);
  }

  question->window = result;
  question->CurrentSource = NO_ITEM_SELECTED;
  question->CurrentRelDoc = NO_ITEM_SELECTED;
  question->CurrentResDoc = NO_ITEM_SELECTED;

  result->shell = (Widget)MakeQuestionPane(top, question);

  ReplaceText(result->keywordwid, question->keywords);

  return(result);
}

Widget
MakeSourcePopup(parent)
Widget parent;
{
  Widget shell, frame, labelwid, stringlabelwid, button;
  WidgetClass wclass;
  static String
    namestring,
  serverstring,
  servicestring,
  dbstring,
  cost, units,
  maintainer,
  description;
  int CurrentSource;

  namestring = "default";
  serverstring = "localhost";
  servicestring = "8000";
  dbstring = "";
  cost = "";
  units = "";
  maintainer = "";
  description = "";

  shell = XtCreatePopupShell("sourcepopup", applicationShellWidgetClass,
			     parent, NULL, ZERO);
  frame = XtCreateManagedWidget("sourcepopupform", formWidgetClass,
				shell, NULL, ZERO);

  labelwid = MakeLabel(frame, "sourceditlabel", "Source Edit", NULL, NULL);

  stringlabelwid = MakeLabel(frame, "sourcenamelabel", "       Name:", labelwid, NULL);
  snamewid = MakeStringBox(frame, "sourcename", namestring, labelwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "serverlabel",     "     Server:", snamewid, NULL);
  serverwid = MakeStringBox(frame, "server", serverstring, snamewid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "servicelabel", "    Service:", serverwid, NULL);
  servicewid = MakeStringBox(frame, "service", serverstring, serverwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "dblabel",      "   Database:", stringlabelwid, NULL);
  dbwid = MakeStringBox(frame, "database", dbstring, servicewid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "costlabel",    "       Cost:", stringlabelwid, NULL);
  costwid = MakeStringBox(frame, "cost", cost, dbwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "unitlabel",    "      Units:", stringlabelwid, NULL);
  unitwid = MakeStringBox(frame, "costunit", units, costwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "maintlabel",   " Maintainer:", stringlabelwid, NULL);
  maintainerwid = MakeStringBox(frame, "maintainer", maintainer, unitwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "desclabel",    "Description:", stringlabelwid, NULL);
  descwid = MakeStringBox(frame, "description", description, stringlabelwid, NULL);

  button = MakeCommandButton(frame, "sdone", DoSSave, descwid, NULL, NULL);
  MakeCommandButton(frame, "cancel", DontSSave, descwid, button, NULL);

  return shell;
}

ScrollList
MakeSourceFrame(parent)
Widget parent;
{
  Widget frame, labelwid, button, view;
  ScrollList result;
  Arg arglist[10];
  Cardinal num_args;

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, "Sources"); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, "Sources"); num_args++;
  sshell = XtCreatePopupShell("sourcepane", transientShellWidgetClass, 
			      parent, arglist, num_args);
  frame = XtCreateManagedWidget("sources", formWidgetClass, sshell, NULL, ZERO);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;*/
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("ssview", viewportWidgetClass,
				frame, arglist, num_args);

  result = (ScrollList) s_malloc(sizeof(_ScrollList));

  result->offset = 0;

  result->ListWidget =
    MakeListWidget(view, "sourceWindow", Source_items, NULL, NULL);

  XtAddCallback(result->ListWidget,
		XtNcallback,
		(XtCallbackProc)AddSourceToQuestion, NULL );

  button = MakeCommandButton(frame, "qsadd", AddSourceToQuestion,
			     view, NULL, NULL);
  return result;
}
