
#include "alexincs.h"
#include "alex.h"

#ifdef ALPHAOSF
#  include <sys/mount.h>
#endif


/*

find | printinfo | sort

    produces output like this:

10000000000000000 Bytes= 80034   Dirs= 0  Files= 35  Unknown= 0
8484 719969143 719969143 604 #F /usr2/alex-cache/edu/utexas/cc/bongo/pub/AI_ATTIC/Languages/Pro
8404 720768639 720586009 512 #D /usr2/alex-cache/com/dec
8084 720768640 720748892 512 #D /usr2/alex-cache/com/dec/crl/pub
7484 720768641 720748897 512 #D /usr2/alex-cache/com/dec/crl/pub/athena


First, call the OS to see how much is free.  Then we will remove files
as needed so that there is at least 2 MB free at all times (checking 
every minute).  We lstat() a file first to see if it has been accessed,
and then do not remove it if it has been.  After working down about 20% 
of the list, or getting to 4 am in the morning, this program exist.  
There is a shell script that does a new find etc and runs this program again.

We do not remove .alex.info files directly, only as a result of removing a 
whole directory subtree.  However, that is not working well now, as
when we do the find|printinfo|sort we read all of the directories, so the
atimes are not old for them.

*/

/* The following should really also check quota() to see if we are
 *  up against a user quota limit.  So KBytesFree should be the 
 *  minimum of disk free on the partition and user quota left.
 * However, it seems that quota() is only BSD and I have not bothered.
 * Since Alex frees up space as it is needed, it is reasonable to 
 * run alexsrvr with unlimited disk space. 
 */

#ifdef ultrix
int KBytesFree()
{
    struct fs_data buf;
    int Result;

    if(statfs(CACHEDIRVAR, &buf) < 1) {
        fprintf(stderr, "CheckForSpace ERROR");
        exit(-1);
    }

    Result =  buf.fd_bfreen;          /* same as  buf.fd_req.bfreen */
    /* buf.fd_bfreen = space available to a user (the 10 percent margin),
       buf.fd_bfree  = space available to root */
    
    return(Result);
}

#else

int KBytesFree()
{
    struct statfs buf;
    int Result;

    if(statfs(CACHEDIRVAR, &buf)) {
        fprintf(stderr, "CheckForSpace ERROR");
        exit(-1);
    }

    Result = (buf.f_bsize/1000.0) * buf.f_bavail;
    return(Result);
}
#endif

fh_fdclose()
{
}


/*  Stat the file to see if it has changed since scan of tree.
 *    If has not changed, then remove it.
 *    Return 1 if removed a file.
 */
int RmIfStillOld(Path, ATime)
char *Path;
int ATime;
{
    struct stat s;

    if (strncmp(Path, CACHEDIRVAR, strlen(CACHEDIRVAR)) != 0) {
        printf("RmIfStillOld was given a filename not in cache - Exiting. %s\n", Path);
        exit(-1);
    }

    if (lstat(Path, &s) != 0) {
        /* printf("Could not stat %s\n", Path); */
    } else {
        if (s.st_atime <= ATime) {
            printf("removing %s\n", Path);
            if (unlink(Path) != 0) {
                printf("RmIfStillOld  ERROR removing %s\n", Path);
            }
            return(1);
        } else {
            printf("File has been accessed %s\n", Path);
        }
    }
    return(0);
}

/* Returns 1 if we were not at 0400 hours and we now are.
 */
int NewlyAfter4AM()
{
    char buf[255];
    struct tm loctm;
    struct timeval tp;
    struct timezone tzp;
    int    status;
    static int LastHour=4;             /* we will usually come up at 4 am */
    int Result, Hour;

    status=gettimeofday(&tp,&tzp);
    loctm = *(localtime(&tp.tv_sec));

    fdate(buf,"%0hour", &loctm);
    printf("%s ", buf);
    Hour=atoi(buf);

    if ((LastHour != 4) && (Hour == 4)) {
        Result=1;
    } else {
        Result=0;
    }
    LastHour=Hour;

    return(Result);
}


/* Might want to use LineToTokens */

FILE *debugLog = NULL;

int RemoveDirectory(Path)
char *Path;
{
    int CurrentKBFree, TmpKBFree, BytesRemoved;

    printf("Removing directory %s\n", Path);
    CurrentKBFree = KBytesFree();
    RecursiveRm(Path, __FILE__, __LINE__, DOWAIT);
    TmpKBFree = KBytesFree();
    BytesRemoved=0;
    if (TmpKBFree > CurrentKBFree) {
        BytesRemoved = TmpKBFree - CurrentKBFree;
    }

    return(BytesRemoved);
}

main()
{
    int TotalBytes, TotalDirs, TotalFiles, TotalUnknown, NumScanned;
    int BytesRmEd, FilesRmEd, NightTime;
    double BadNess;
    int   ATime, MTime, Bytes, Done, CurrentKBFree;
    int UID;
    char Type, Path[MAXPATH], TmpPath[MAXPATH];
    double Age, AgeOfYoungestFileRemoved;

    (void) strcpy(TmpPath, TMPDIR);
    (void) strcat(TmpPath, "evictor.log");
    SetLogBaseName(TmpPath);

    InitAlexUidVar();
    InitReadOnlyVariables();
    UID=geteuid();

    if (UID == 0) {
        printf("Should run as alexsrvr so we will change UIDs\n");
        SetUidGid();
    } else if (UID != ALEXUIDVAR) {
        printf("This must be run as alexsrvr not %d\n", UID);
        exit(-1);
    }

    NumScanned=scanf("%lf Bytes= %d   Dirs= %d  Files= %d  Unknown= %d\n",
                   &BadNess, &TotalBytes, &TotalDirs, &TotalFiles, &TotalUnknown);

    if (NumScanned != 5) {
        printf("Could not scanf the first line. NumScanned = %d.   Exiting.\n", NumScanned);
        exit(-1);
    }

    printf("%lf Bytes = %d   Dirs = %d  Files = %d  Unknown = %d\n",
                   BadNess, TotalBytes, TotalDirs, TotalFiles, TotalUnknown);

    printf("MINFREEKB is %d\n", MINFREEKB);

    AgeOfYoungestFileRemoved=729151876;                    /* born in 1970 */
    BytesRmEd=0;
    FilesRmEd=0;
    NightTime=0;
    Done=0;
    clearerr(stdin);
    while (!Done) {
        CurrentKBFree = KBytesFree();
#if DEBUGLEVEL > 5
        printf("%d  %d\n", CurrentKBFree, BytesRmEd);
#else
        printf("%d\n", CurrentKBFree);
#endif
        fflush(stdout);
        if (CurrentKBFree < MINFREEKB) {
            NumScanned=scanf("%lf %d %d %d #%c %s\n", &BadNess, &ATime, &MTime, &Bytes, &Type, Path);

            Age = TimeInSeconds() - ATime;

            if (NumScanned != 6) {
                printf("Error reading input\n");
                Done=1;
            } else {
                if (Type == 'D') {     
                    BytesRmEd += RemoveDirectory(Path);
                } else if ((Type == 'F') && (HasString(Path, ALEXINFO))) {
                  /*  printf("Removing directory .alex.info is in %s\n", Path);
                   *  PathToDir(Path, TmpPath);
                   *  BytesRmEd = RemoveDirectory(TmpPath);
                   */
                    printf("Not going to remove #%c %s\n", Type, Path);

                } else if ((Type != 'F') || (HasString(Path, ALEXERROR))) {
                    printf("Not going to remove #%c %s\n", Type, Path);

                } else {
                    if ((Age > 3600*24*2) && (Age < AgeOfYoungestFileRemoved)) {
                        AgeOfYoungestFileRemoved = Age;
                    }
                    if (RmIfStillOld(Path, ATime)) {
                        BytesRmEd += Bytes;
                        FilesRmEd ++;
                    }
                }
            }
        } else {
            sleep( (unsigned) 60);
        }

        if (BytesRmEd > (0.5 * TotalBytes)) {    /* BytesRmEd is off now because of RecursiveRm */
            printf("Removed enough bytes\n");
            Done=1;
        }
        if (FilesRmEd > (0.5 * TotalFiles)) {
            printf("Removed enough files\n");
            Done=1;
        }
        if (NewlyAfter4AM())  {
            printf("Enough for tonight\n");
            Done=1;
        }
        if (ferror(stdin)) {
            printf("Error on stdin\n");
            Done=1;
        }
    }
}


