/*
********************************************************************************
* Copyright (c) 1988 by Hewlett-Packard Company
* 
* Permission to use, copy, modify, and distribute this software 
* and its documentation for any purpose and without fee is hereby 
* granted, provided that the above copyright notice appear in all 
* copies and that both that copyright notice and this permission 
* notice appear in supporting documentation, and that the name of 
* Hewlett-Packard not be used in advertising or publicity pertaining 
* to distribution of the software without specific, written prior 
* permission.
********************************************************************************
*/

/*************************************<->*************************************
 *
 *   PrintGraph routines for the Graph widget
 *   -----------
 *
 *************************************<->***********************************/

#include	<stdio.h>
#include 	<Xm/Xm.h>
#include 	<Xm/XmP.h>
#include	"GraphP.h"
#include	"Graph.h"
#include	"Arc.h"
#include	"ArcP.h"

void		PrintGraph();

PrintNodeList (nlist)
    NodeList *nlist;
{
    if (nlist->n_nodes == 0)
	printf (" NULL \n");
    else {
	NList nodes = nlist->nodes;
	int i;

	for (i = 0; i < nlist->n_nodes; i++) 
	    printf (" %s ", XtName(nodes[i]->widget));
	printf ("\n");
    }
}

PrintArcList (alist)
    ArcList  *alist;
{
    printf (" n_arcs: %d n_slots: %d ", alist->n_arcs, alist->n_slots);
    if (alist->n_arcs == 0)
	printf (" NULL \n");
    else {
	int i = 0;
	WidgetList arcs = alist->arcs;
	
	for ( i = 0; i < alist->n_arcs; i++)
	    printf (" %s ", ((XmArcWidget) arcs[i])->arc.name);
	printf ("\n");
    }
}

void PrintArc (arc)
    XmArcWidget  arc;
/* Prints the fields of the arc widget  */
{
    printf (" ARC name: %s from_x: %d from_y: %d to_x: %d to_y: %d \n",
	    arc->arc.name, arc->arc.from_x, arc->arc.from_y,
	     arc->arc.to_x, arc->arc.to_y);
    printf ("              from-node: %s, to-node: %s, direction: %s \n",
	    XtName(arc->arc.from), XtName(arc->arc.to),
	    arc->arc.direction);
    printf (" With siblings: ");
    PrintArcList (arc->arc.siblings);
}

void PrintNodeWidget (w)
    Widget  w;
/* Prints the core fields of the widget  */
{
    printf (" NODE name: %s x: %d y: %d width: %d height: %d \n",
	    XtName(w), RX(w), RY(w), RWidth(w), RHeight(w));
}

void PrintNode (node)
    NodePtr node;
/* Prints the fields of the node and its widget  */
{
    PrintNodeWidget (node->widget);
    printf (" #tree_kids: %d, level: %d \n", node->tree_kids.n_nodes, node->level);
    printf (" treeDad: ");
    if (node->tree_parent == NULL)
	printf (" NULL \n");
    else
	printf (" %s \n", XtName(node->tree_parent->widget));
    printf (" visited: ");
    if (node->visited)
	printf (" TRUE \n");
    else
	printf (" FALSE \n");
    printf (" Parents: ");
    PrintNodeList (&(node->parents));
    printf (" Kids: ");
    PrintNodeList (&(node->kids));
    printf (" tree_kids: ");
    PrintNodeList (&(node->tree_kids));
    printf (" from_arcs: ");
    PrintArcList (&(node->from_arcs));
    printf (" to_arcs: ");
    PrintArcList (&(node->to_arcs));
    printf ( "\n");
}

void PrintCurrNode (graph)
    XmGraphWidget  graph;
{
    if (graph->graph.current_node)
	PrintNode (graph->graph.current_node);
}

/* Prints the fields of the graph widget  */
PrintGraphWidget (graph)
    XmGraphWidget  graph;
{
    printf (" Graph name: %s x: %d y: %d width: %d height: %d \n",
	    XtName(graph), RX(graph), RY(graph), RWidth(graph),
	    RHeight(graph));
    printf (" #kids: %d, #slots: %d, \n",
	    graph->composite.num_children, graph->composite.num_slots,
	    graph->composite);
    printf ("start_x: %d, start_y: %d, end_x: %d, end_y: %d, delta_x: %d, delta_y: %d \n",
	    graph->graph.start_x, graph->graph.start_y, graph->graph.end_x, graph->graph.end_y,
	    graph->graph.delta_x, graph->graph.delta_y);
    printf ("child_sp: %d, sibling_sp: %d, edit_mode: %d, auto_lay: %d, layed?: %d \n",
	    graph->graph.child_spacing, graph->graph.sibling_spacing, graph->graph.edit_mode,
	    graph->graph.auto_layout_mode, graph->graph.layed_out);
    printf ("direction: %s, n_arcs: %d, n_nodes: %d\n",
	    graph->graph.direction, graph->graph.n_arcs, graph->graph.n_nodes);
    if (graph->graph.current_node)
	printf ("curr_node: %s ", XtName(graph->graph.current_node->widget));
    if (graph->graph.current_arc)
	printf ("curr_arc: %s ", XtName(graph->graph.current_arc));
    printf ( " \n \n");
}

PrintNodes (graph)
    XmGraphWidget  graph;
{
    int i;

    for (i = 0; i < graph->graph.n_nodes; i++)
	PrintNode (NODEPTR(graph->composite.children[i]));
}

PrintArcs (graph)
    XmGraphWidget  graph;
{
  WidgetList  arcs;
  int         i = 0;

  if (graph->graph.arcs != NULL)
    for (i = 0; i < graph->graph.n_arcs; i++) 
      PrintArc (graph->graph.arcs[i]);
}

void PrintCurrArc (graph)
    XmGraphWidget  graph;
{
  if (graph->graph.current_arc)
    PrintArc (graph->graph.current_arc);
}

void PrintGraph (graph)
    XmGraphWidget  graph;
{
    PrintGraphWidget (graph);
    PrintNodes (graph);
    PrintArcs (graph);
}
