# Note: this file has been initially generated by Module::Build::Convert 0.25

use strict;
use warnings;
use Module::Build;
use Getopt::Long;

my $XML_parser;
GetOptions( 'parser=s' => \$XML_parser );

if( $XML_parser )
{
	unless( grep $XML_parser eq $_, qw/ XML::XPath XML::LibXML / )
	{
		die "XML parser $XML_parser not supported\n",
            "please choose XML::XPath or XML::LibXML\n";
	}
	print "XML parser configured to be $XML_parser\n";
} else {
	print "detecting XML parser...\n",
	      "checking if XML::LibXML is present.. ";
	eval "use XML::LibXML";
	unless( $@ )
	{
		print "XML::LibXML detected, good!\n",
              "setting XML parser to XML::LibXML\n";
		$XML_parser = 'XML::LibXML';
	} else {
		print "XML::LibXML not detected, drat\n";
		print "checking if XML::XPath is present.. ";
		eval "use XML::XPath";
		unless( $@ )
		{
			print "XML::XPath detected\nsetting XML parser to XML::XPath\n";
			$XML_parser = 'XML::XPath';
		} else {
			print "XML::XPath not found\n";
			die "XML::XPathScript needs either XML::LibXML or ",
                "XML::XPath to be installed\n";
		}
	}
}

my ($with_axkit, $with_tomkit) = (0, 0);
print <<"MESSAGE" if eval "use AxKit; $with_axkit = 1";
AxKit detected, adding Apache::Axkit::Language::YPathScript to
installation
MESSAGE
print <<"MESSAGE" if eval "use Apache2::TomKit; $with_tomkit = 1";
TomKit detected, adding Apache2::Tomkit::Processor::XPathScript to
installation
MESSAGE

my $class = Module::Build->subclass
    (code => <<"PROPAGATE_VARIABLES"
our \$XML_parser = '$XML_parser';
our \$with_axkit = '$with_axkit';
our \$with_tomkit = '$with_tomkit';
PROPAGATE_VARIABLES
     . <<'CODE');
use strict;
use warnings;

use File::Find;
use File::Spec ();

sub find_pm_files {
    my $self = shift;
    my $result = $self->SUPER::find_pm_files(@_);
    my @extra_lib_dirs;
    push @extra_lib_dirs, "lib_axkit" if $with_axkit;
    push @extra_lib_dirs, "lib_tomkit" if $with_tomkit;
    return $result ;
    find ({ no_chdir => 1,
            wanted => sub {
                $result->{$File::Find::name} = $File::Find::name
                     if m/\.pm$/ },
            }, @extra_lib_dirs) if @extra_lib_dirs;
    return $result;
}

sub process_pm_files {
    my $self = shift;
    $self->SUPER::process_pm_files(@_);

    my $outfile = File::Spec->catfile(qw(blib lib XML XPathScript.pm));
    unlink($outfile);
    my $in = new IO::File("XPathScript.pm", "<") or die "$!";
    my $out = new IO::File($outfile, ">") or die "$!";
    while(<$in>) {
          s/^(\$XML_parser = )'.*?';$/$1'$XML_parser';/;
          $out->print($_);
      }
}

CODE

my $build = $class->new
  (
   module_name => 'XML::XPathScript',
   dist_author => 'Yanick Champoux <yanick@cpan.org>, '
                    .'Dominique Quatravaux <dom@idealx.com> '
                    .'and Matt Sergeant <matt@sergeant.org>',
   dist_version_from => 'XPathScript.pm',
   license => 'artistic',
   requires => {
                "Carp" => 0,
                "Symbol" => 0,
                "File::Basename" => 0,
                "IO::File" => 0,
                "Data::Dumper" => 0,
                "Scalar::Util" => 0,
               },
   build_requires => {
                      "File::Find" => 0,
                      "File::Spec" => 0,
                     },
   create_makefile_pl => 'passthrough',
  );

$build->create_build_script;
