package BIE::Data::HDF5;

use 5.014002;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use BIE::Data::HDF5 ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	H5Fopen
	H5Fclose
	H5Dopen
	H5Dread
	H5Dprint
);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('BIE::Data::HDF5', $VERSION);

# Preloaded methods go here.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

BIE::Data::HDF5 - Perl extension for blah with HDF5.

=head1 SYNOPSIS

  use BIE::Data::HDF5;
  
=head1 DESCRIPTION

BIE::Data::HDF5 is an interface to operate Hierarchical Data Format 5. 
Now it only reads h5 files. Writing capability is coming soon.

=head2 EXPORT

None by default.

=head1 SEE ALSO

L<HDF5 website|http://www.hdfgroup.org>

=head1 AUTHOR

Xin Zheng, E<lt>zhengxin@mail.nih.govE<gt>

This work is being inspired by problems in daily work at 
Laboratory of Bioinformatics and Immunopathogenesis at Frederick National 
Lab for Cancer Research. Many thanks for our team. Be proud of 
our excellent work in HIV/AIDS study. And of course, FNL doesn't take any 
responsiblity caused by using this module, the only one to be blamed is 
listed above.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2012 by Xin Zheng

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.14.2 or,
at your option, any later version of Perl 5 you may have available.

=cut
