package Data::UUID::Base64URLSafe;
use 5.008001;
use strict;
use warnings;

our $VERSION = "0.01";

use base qw( Data::UUID );

sub new {
    my $class = shift;
    return bless $class->SUPER::new(), $class;
};

use MIME::Base64;

sub create_b64url {
    my $self = shift;
    my $uuid = $self->create();
    return MIME::Base64::encode_base64url($uuid);
}

sub create_from_name_b64url {
    my $self = shift;
    my $uuid = $self->create_from_name(@_);
    return MIME::Base64::encode_base64url($uuid);
}

sub to_b64string {
    my $self = shift;
    my $str = shift;
    return MIME::Base64::encode_base64url($str);
}

sub from_b64string {
    my $self = shift;
    my $str = shift;
    $str =~ tr[-_][+/] if $str =~ m|[-_]|;
    return MIME::Base64::decode_base64($str);
}

1;
__END__

=encoding utf-8

=head1 NAME

 Data::UUID::Base64URLSafe - getting Data::UUID with URLSafe strings

=head1 SYNOPSIS

 use Data::UUID::Base64URLSafe;
 my $dub = Data::UUID::Base64URLSafe->new();
 my $uuid = $dub->create_b64url();                                  # from nothing
 $uuid = $dub->create_from_name_b64url( <namespace>, <string> );    # from namespace and string
 my $str = $dub->from_b64string(<UUID-URLSafe>);                    # decoding from UUID-URLSafe
 my $uuid2 = $dub->to_b64string($str);                              # encoding from binary

=head1 DESCRIPTION

Data::UUID::Base64URLSafe is a wrapper module for Data::UUID.
It makes 22 length strings with URLS-Safe characters.

It will help you when you wanna make user-ID on your web applications.

=head1 LICENSE

Copyright (C) Yuki Yoshida.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHOR

Yuki Yoshida E<lt>worthmine@gmail.comE<gt>

=cut

