#!perl

use strict;
use warnings;

use Variable::Temp 'temp';

use Test::More tests => 16;

{
 package Variable::Temp::TestDestructor;

 sub new {
  my ($class, $code) = @_;
  bless { code => $code }, $class;
 }

 sub DESTROY {
  $_[0]->{code}->();
 }
}

my $x_is_destroyed       = 0;
my $x_temp1_is_destroyed = 0;
my $x_temp2_is_destroyed = 0;

{
 my $x = Variable::Temp::TestDestructor->new(sub {
  is $x_temp1_is_destroyed, 1;
  is $x_temp2_is_destroyed, 1;
  ++$x_is_destroyed;
 });
 is $x_is_destroyed, 0;

 temp $x = Variable::Temp::TestDestructor->new(sub {
  is $x_is_destroyed,       0;
  is $x_temp2_is_destroyed, 1;
  ++$x_temp1_is_destroyed;
 });
 is $x_is_destroyed,       0;
 is $x_temp1_is_destroyed, 0;
 is $x_temp2_is_destroyed, 0;

 temp $x = Variable::Temp::TestDestructor->new(sub {
  is $x_is_destroyed,       0;
  is $x_temp1_is_destroyed, 0;
  ++$x_temp2_is_destroyed;
 });
 is $x_is_destroyed,       0;
 is $x_temp1_is_destroyed, 0;
 is $x_temp2_is_destroyed, 0;
}

is $x_is_destroyed,       1;
is $x_temp1_is_destroyed, 1;
is $x_temp2_is_destroyed, 1;
