package ExtUtils::MakeMaker::Coverage;

use warnings;
use strict;

=head1 NAME

ExtUtils::MakeMaker::Coverage - add a Makefile target to determine
test coverage using Devel::Cover

=head1 VERSION

Version 0.01_01

=cut

our $VERSION = '0.01_01';

=head1 SYNOPSIS

This module adds an additional target to the Makefile generated by
C<ExtUtils::MakeMaker>.  The target, C<testcover>, calls C<cover>, 
the command-line script to generate test coverage statistics, to clean
up any data from a previous run.  It then runs the tests, as if 
C<make test> was run, then calls C<cover> again to generate the 
coverage statistics.

    # In Makefile.PL
    use ExtUtils::MakeMaker;
    use ExtUtils::MakeMaker::Coverage;

In your shell

    > perl Makefile.PL
    > make
    > make testcover

=head1 TODO

This is alpha quality code in terms of features.  For this module
to be usable for the as many modules as possible, the following
additional features are needed.

=over

=item C<MY::postamble>

This module will have issues if the C<Makefile> already has a 
My::postamble defined for it.

=item C<Devel::Cover> and C<cover>

This module doesn't care if C<Devel::Cover> is installed or if 
C<cover> is in the path.  This should be changed.

=back

=head1 AUTHOR

Steve Peters, C<< <steve@fisharerojo.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-extutils-makemaker-coverage@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.  I will be notified, and then you'll automatically
be notified of progress on your bug as I make changes.

=head1 ACKNOWLEDGEMENTS

=over

=item Paul Johnson

For developing C<Devel::Cover> and enduring my many questions on IRC.

=item Andy Lester

For helping to make me a test-infected Perl programmer.

=back

=head1 SEE ALSO

=over

=item L<Devel::Cover>

=item L<http://qa.perl.org>

=back

=head1 COPYRIGHT & LICENSE

Copyright 2005 Steve Peters, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

package MY;

sub postamble {
    return <<'END';
COVER = cover

coverclean:
	$(COVER) -delete

testcover: coverclean
	HARNESS_PERL_SWITCHES=-MDevel::Cover PERL_DL_NONLAZY=1 $(FULLPERLRUN) "-MExtUtils::Command::MM" "-e" "test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')" $(TEST_FILES)
	$(COVER)
END
}

1; # End of ExtUtils::MakeMaker::Coverage
