
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Riap::Simple client",
  "dist_author" => [
    "Steven Haryanto <stevenharyanto\@gmail.com>"
  ],
  "dist_name" => "Perinci-Access-Simple-Client",
  "dist_version" => "0.14",
  "license" => "perl",
  "module_name" => "Perinci::Access::Simple::Client",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "JSON" => 0,
    "Log::Any" => 0,
    "Perinci::Access::Base" => "0.29",
    "Riap" => "v1.1.17",
    "String::ShellQuote" => 0,
    "Tie::Cache" => 0,
    "URI" => 0,
    "URI::Escape" => 0,
    "perl" => "5.010001"
  },
  "script_files" => [],
  "test_requires" => {
    "Test::More" => "0.98"
  }
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  my $tr = delete $module_build_args{test_requires};
  my $br = $module_build_args{build_requires};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
