# $Id: EventGeneratorI.pm,v 1.11.4.1 2006/10/02 23:10:17 sendu Exp $
#
# BioPerl module for Bio::Event::EventGeneratorI
#
# Cared for by Jason Stajich <jason@bioperl.org>
#
# Copyright Jason Stajich
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::Event::EventGeneratorI - This interface describes the basic event
generator class.

=head1 SYNOPSIS

    # Do not use this object directly
    # This object has the basic methods for describing an event generator

=head1 DESCRIPTION

This object describes the basic event generator system.  It basically
allows one to attach one or many event handlers.

=head1 FEEDBACK

=head2 Mailing Lists

User feedback is an integral part of the evolution of this and other
Bioperl modules. Send your comments and suggestions preferably to
the Bioperl mailing list.  Your participation is much appreciated.

  bioperl-l@bioperl.org                  - General discussion
  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists

=head2 Reporting Bugs

Report bugs to the Bioperl bug tracking system to help us keep track
of the bugs and their resolution. Bug reports can be submitted via the
web:

  http://bugzilla.open-bio.org/

=head1 AUTHOR - Jason Stajich

Email jason@bioperl.org

=head1 APPENDIX

The rest of the documentation details each of the object methods.
Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::Event::EventGeneratorI;
use strict;

use base qw(Bio::Root::RootI);

=head2 attach_EventHandler

 Title   : attach_EventHandler
 Usage   : $parser->attatch_EventHandler($handler)
 Function: Adds an event handler to listen for events
 Returns : none
 Args    : Bio::Event::EventHandlerI

=cut

sub attach_EventHandler{
    my ($self) = @_;
    $self->throw_not_implemented();
}

1;
