# -*- perl -*-
# /t/000_basic/005_signature.t - verify signed distribution
# $Id: 005_signature.t 20 2008-05-22 23:09:05Z sanko@cpan.org $
use strict;
use warnings;
use Test::More;
plan skip_all => q[TODO];

#if ( not $ENV{RELEASE_TESTING} ) {
#    plan( skip_all =>
#        q[Release test.  Set $ENV{RELEASE_TESTING} to a true value to run.]
#    );
#}
if (!eval { require Module::Signature; 1 }) {
    plan skip_all => q[Module::Signature required to verify distribution];
}
elsif (!-e q[SIGNATURE]) {
    plan skip_all => q[SIGNATURE not found];
}
elsif (-s q[SIGNATURE] == 0) {
    plan skip_all => q[SIGNATURE file empty];
}
elsif (!eval { require Socket; Socket::inet_aton(q[pgp.mit.edu]) }) {
    plan skip_all =>
        q[Cannot connect to the keyserver to check module signature];
}
else {
    plan tests => 1;
}
unlink(qw[pod2htmd.tmp pod2htmi.tmp]);    # Thanks, M::B! >.>
my $ret = Module::Signature::verify({skip => q[Build.bat]});
SKIP: {
    skip q[Module::Signature cannot verify], 1
        if $ret eq Module::Signature::CANNOT_VERIFY();
    cmp_ok $ret, q[==], Module::Signature::SIGNATURE_OK(), q[Valid signature];
}
