/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.backend;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.handler.JsonRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerHandler {
    private Set<MBeanServer> mBeanServers;
    private Set<MBeanServerConnection> mBeanServerConnections;
    private boolean isJBoss = this.checkForClass("org.jboss.mx.util.MBeanServerLocator");

    public MBeanServerHandler() {
        this.initMBeanServers();
    }

    public Object dispatchRequest(JsonRequestHandler pRequestHandler, JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        if (pRequestHandler.handleAllServersAtOnce()) {
            try {
                return pRequestHandler.handleRequest(this.mBeanServerConnections, pJmxReq);
            }
            catch (IOException e) {
                throw new IllegalStateException("Internal: IOException " + e + ". Shouldn't happen.", e);
            }
        }
        try {
            this.wokaroundJBossBug(pJmxReq);
            AttributeNotFoundException attrException = null;
            InstanceNotFoundException objNotFoundException = null;
            for (MBeanServer s : this.mBeanServers) {
                try {
                    return pRequestHandler.handleRequest(s, pJmxReq);
                }
                catch (InstanceNotFoundException exp) {
                    objNotFoundException = exp;
                }
                catch (AttributeNotFoundException exp) {
                    attrException = exp;
                }
                catch (IOException exp) {
                    throw new IllegalStateException("I/O Error while dispatching", exp);
                }
            }
            if (attrException != null) {
                throw attrException;
            }
            throw objNotFoundException;
        }
        catch (ReflectionException e) {
            throw new IllegalStateException("Internal error for '" + pJmxReq.getAttributeName() + "' on object " + pJmxReq.getObjectName() + ": " + e, e);
        }
        catch (MBeanException e) {
            throw new IllegalStateException("Exception while fetching the attribute '" + pJmxReq.getAttributeName() + "' on object " + pJmxReq.getObjectName() + ": " + e, e);
        }
    }

    public ObjectName registerMBean(Object pMBean, String ... pName) throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        if (this.mBeanServers.size() > 0) {
            Exception lastExp = null;
            for (MBeanServer server : this.mBeanServers) {
                try {
                    if (pName != null && pName.length > 0) {
                        ObjectName oName = new ObjectName(pName[0]);
                        return server.registerMBean(pMBean, oName).getObjectName();
                    }
                    return server.registerMBean(pMBean, null).getObjectName();
                }
                catch (Exception exp) {
                    lastExp = exp;
                }
            }
            if (lastExp != null) {
                throw new IllegalStateException("Could not register " + pMBean + ": " + lastExp, lastExp);
            }
        }
        throw new IllegalStateException("No MBeanServer initialized yet");
    }

    public void unregisterMBean(ObjectName pMBeanName) throws MBeanRegistrationException, InstanceNotFoundException, MalformedObjectNameException {
        if (this.mBeanServers.size() <= 0) {
            throw new IllegalStateException("No MBeanServer initialized yet");
        }
        this.mBeanServers.iterator().next().unregisterMBean(pMBeanName);
    }

    public Set<MBeanServer> getMBeanServers() {
        return Collections.unmodifiableSet(this.mBeanServers);
    }

    private void initMBeanServers() {
        this.mBeanServers = new LinkedHashSet<MBeanServer>();
        this.addJBossMBeanServer(this.mBeanServers);
        this.addWebsphereMBeanServer(this.mBeanServers);
        this.addFromMBeanServerFactory(this.mBeanServers);
        this.addFromJndiContext(this.mBeanServers);
        this.mBeanServers.add(ManagementFactory.getPlatformMBeanServer());
        if (this.mBeanServers.size() == 0) {
            throw new IllegalStateException("Unable to locate any MBeanServer instance");
        }
        this.mBeanServerConnections = new LinkedHashSet<MBeanServerConnection>();
        for (MBeanServer server : this.mBeanServers) {
            this.mBeanServerConnections.add(server);
        }
    }

    private void addFromJndiContext(Set<MBeanServer> servers) {
        try {
            InitialContext ctx = new InitialContext();
            MBeanServer server = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
            if (server != null) {
                servers.add(server);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void addWebsphereMBeanServer(Set<MBeanServer> servers) {
        try {
            Class<?> adminServiceClass = this.getClass().getClassLoader().loadClass("com.ibm.websphere.management.AdminServiceFactory");
            Method getMBeanFactoryMethod = adminServiceClass.getMethod("getMBeanFactory", new Class[0]);
            Object mbeanFactory = getMBeanFactoryMethod.invoke(null, new Object[0]);
            Method getMBeanServerMethod = mbeanFactory.getClass().getMethod("getMBeanServer", new Class[0]);
            servers.add((MBeanServer)getMBeanServerMethod.invoke(mbeanFactory, new Object[0]));
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Internal: Found AdminServiceFactory but can not call methods on it (wrong WAS version ?)", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Internal: Found AdminServiceFactory but can not call methods on it (wrong WAS version ?)", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Internal: Found AdminServiceFactory but can not call methods on it (wrong WAS version ?)", ex);
        }
    }

    private void addJBossMBeanServer(Set<MBeanServer> servers) {
        try {
            Class<?> locatorClass = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            Method method = locatorClass.getMethod("locateJBoss", new Class[0]);
            servers.add((MBeanServer)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void addFromMBeanServerFactory(Set<MBeanServer> servers) {
        ArrayList<MBeanServer> beanServers = MBeanServerFactory.findMBeanServer(null);
        if (beanServers != null) {
            servers.addAll(beanServers);
        }
    }

    private void wokaroundJBossBug(JmxRequest pJmxReq) throws ReflectionException, InstanceNotFoundException {
        if (this.isJBoss && pJmxReq.getObjectName() != null && "java.lang".equals(pJmxReq.getObjectName().getDomain())) {
            try {
                for (MBeanServer s : this.mBeanServers) {
                    try {
                        s.getMBeanInfo(pJmxReq.getObjectName());
                        return;
                    }
                    catch (InstanceNotFoundException exp) {
                    }
                }
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("Workaround for JBoss failed for object " + pJmxReq.getObjectName() + ": " + e);
            }
        }
    }

    private boolean checkForClass(String pClassName) {
        try {
            Class.forName(pClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

