/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Config {
    HISTORY_MAX_ENTRIES("historyMaxEntries", "10"),
    DEBUG("debug", "false"),
    DEBUG_MAX_ENTRIES("debugMaxEntries", "100"),
    DISPATCHER_CLASSES("dispatcherClasses"),
    MAX_DEPTH("maxDepth", "0"),
    MAX_COLLECTIONS_SIZE("maxCollectionSize", "0"),
    MAX_OBJECTS("maxObjects", "0"),
    AGENT_CONTEXT("agentContext", "/j4p"),
    USER("user"),
    PASSWORD("password");

    private String key;
    private String defaultValue;
    private static Map<String, Config> keyByName;

    private Config(String pValue) {
        this(pValue, null);
    }

    private Config(String pValue, String pDefault) {
        this.key = pValue;
        this.defaultValue = pDefault;
    }

    public String toString() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getByKey(String pKeyS) {
        if (keyByName != null) return keyByName.get(pKeyS);
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            keyByName = new HashMap<String, Config>();
            for (Config ck : Config.values()) {
                keyByName.put(ck.getKeyValue(), ck);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return keyByName.get(pKeyS);
        }
    }

    public String getKeyValue() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getValue(Map<Config, String> pConfig) {
        String value = pConfig.get((Object)this);
        if (value == null) {
            value = this.getDefaultValue();
        }
        return value;
    }
}

