package Bencher::Scenario::HumanDateParsingModules::Startup;

our $DATE = '2016-07-17'; # DATE
our $VERSION = '0.005'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup overhead of some human date parsing modules',
    module_startup => 1,
    participants => [
        {module=>'DateTime::Format::Alami::EN'},
        {module=>'DateTime::Format::Alami::ID'},
        {module=>'DateTime::Format::Flexible'},
        {module=>'DateTime::Format::Natural'},
        {module=>'DateTime'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of some human date parsing modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::HumanDateParsingModules::Startup - Benchmark startup overhead of some human date parsing modules

=head1 VERSION

This document describes version 0.005 of Bencher::Scenario::HumanDateParsingModules::Startup (from Perl distribution Bencher-Scenarios-HumanDateParsingModules), released on 2016-07-17.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m HumanDateParsingModules::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<DateTime::Format::Alami::EN> 0.13

L<DateTime::Format::Alami::ID> 0.13

L<DateTime::Format::Flexible> 0.26

L<DateTime::Format::Natural> 1.03

L<DateTime> 1.26

=head1 BENCHMARK PARTICIPANTS

=over

=item * DateTime::Format::Alami::EN (perl_code)

L<DateTime::Format::Alami::EN>



=item * DateTime::Format::Alami::ID (perl_code)

L<DateTime::Format::Alami::ID>



=item * DateTime::Format::Flexible (perl_code)

L<DateTime::Format::Flexible>



=item * DateTime::Format::Natural (perl_code)

L<DateTime::Format::Natural>



=item * DateTime (perl_code)

L<DateTime>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m HumanDateParsingModules::Startup >>):

 #table1#
 {dataset=>undef}
 +-----------------------------+-----------+------------------------+------------+-----------+---------+
 | participant                 | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +-----------------------------+-----------+------------------------+------------+-----------+---------+
 | DateTime::Format::Flexible  |      73   |                   70.5 |        1   |   0.00014 |      21 |
 | DateTime::Format::Natural   |      58   |                   55.5 |        1.2 | 7.9e-05   |      20 |
 | DateTime                    |      36   |                   33.5 |        2   | 6.8e-05   |      21 |
 | DateTime::Format::Alami::EN |      16   |                   13.5 |        4.6 |   0.00012 |      20 |
 | DateTime::Format::Alami::ID |      15   |                   12.5 |        4.8 | 3.7e-05   |      20 |
 | perl -e1 (baseline)         |       2.5 |                    0   |       29   | 9.1e-06   |      20 |
 +-----------------------------+-----------+------------------------+------------+-----------+---------+

=begin html

<img src="data:image/png;base64,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" />

=end html


=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-HumanDateParsingModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DateTimeFormatAlami>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-HumanDateParsingModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
