package Bencher::Scenario::DataComparisonModules::Compare;

our $DATE = '2018-08-12'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark data comparison modules',
    modules => {
        'Data::Compare' => {version=>0},
        'Data::Cmp' => {version=>0.002},
        'Test::Deep::NoTest' => {version=>0},
    },
    participants => [
        {
            fcall_template => 'Data::Compare::Compare(<d1>, <d2>)',
        },
        {
            fcall_template => 'Data::Cmp::cmp_data(<d1>, <d2>)',
        },
        {
            name => 'Test::Deep::NoTest::eq_deeply',
            module => 'Test::Deep::NoTest',
            code_template => 'use Test::Deep::NoTest; eq_deeply(<d1>, <d2>)',
        },
    ],
    datasets => [
        {name => 'simple scalar' , args=>{d1=>1, d2=>1}},
        {name => 'array len=10'  , args=>{d1=>[1..10], d2=>[1..10]}},
        {name => 'array len=1000', args=>{d1=>[1..1000], d2=>[1..1000]}},
        {name => 'hash keys=10'  , args=>{d1=>{1..20}, d2=>{1..20}}},
        {name => 'hash keys=1000', args=>{d1=>{1..2000}, d2=>{1..2000}}},
    ],
};

1;
# ABSTRACT: Benchmark data comparison modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataComparisonModules::Compare - Benchmark data comparison modules

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::DataComparisonModules::Compare (from Perl distribution Bencher-Scenarios-DataComparisonModules), released on 2018-08-12.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataComparisonModules::Compare

To run module startup overhead benchmark:

 % bencher --module-startup -m DataComparisonModules::Compare

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Cmp> 0.002

L<Data::Compare> 1.25

L<Test::Deep::NoTest>

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::Compare::Compare (perl_code)

Function call template:

 Data::Compare::Compare(<d1>, <d2>)



=item * Data::Cmp::cmp_data (perl_code)

Function call template:

 Data::Cmp::cmp_data(<d1>, <d2>)



=item * Test::Deep::NoTest::eq_deeply (perl_code)

Code template:

 use Test::Deep::NoTest; eq_deeply(<d1>, <d2>)



=back

=head1 BENCHMARK DATASETS

=over

=item * simple scalar

=item * array len=10

=item * array len=1000

=item * hash keys=10

=item * hash keys=1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.26.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 18.3 >>, OS kernel: I<< Linux version 4.10.0-38-generic >>.

Benchmark with default options (C<< bencher -m DataComparisonModules::Compare >>):

 #table1#
 +-------------------------------+----------------+-----------+-----------+------------+---------+---------+
 | participant                   | dataset        | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------------+----------------+-----------+-----------+------------+---------+---------+
 | Data::Compare::Compare        | hash keys=1000 |       220 |   4.6     |        1   | 1.6e-05 |      20 |
 | Data::Compare::Compare        | array len=1000 |       300 |   3.3     |        1.4 | 4.2e-06 |      21 |
 | Test::Deep::NoTest::eq_deeply | hash keys=1000 |       380 |   2.6     |        1.8 | 8.3e-06 |      20 |
 | Data::Cmp::cmp_data           | hash keys=1000 |       640 |   1.6     |        2.9 | 3.1e-06 |      20 |
 | Data::Cmp::cmp_data           | array len=1000 |      1000 |   0.97    |        4.7 | 4.1e-06 |      20 |
 | Test::Deep::NoTest::eq_deeply | array len=1000 |      1400 |   0.69    |        6.6 | 2.2e-06 |      21 |
 | Test::Deep::NoTest::eq_deeply | hash keys=10   |      6500 |   0.15    |       30   | 2.6e-07 |      21 |
 | Test::Deep::NoTest::eq_deeply | array len=10   |      8400 |   0.12    |       38   | 2.1e-07 |      20 |
 | Data::Compare::Compare        | hash keys=10   |     17000 |   0.058   |       80   | 9.5e-08 |      25 |
 | Data::Compare::Compare        | array len=10   |     25600 |   0.039   |      118   | 1.3e-08 |      21 |
 | Data::Cmp::cmp_data           | hash keys=10   |     64000 |   0.016   |      290   | 2.7e-08 |      20 |
 | Data::Cmp::cmp_data           | array len=10   |     87000 |   0.012   |      400   | 1.2e-08 |      26 |
 | Test::Deep::NoTest::eq_deeply | simple scalar  |    174000 |   0.00576 |      796   | 1.7e-09 |      20 |
 | Data::Compare::Compare        | simple scalar  |    450000 |   0.0022  |     2000   | 2.8e-09 |      28 |
 | Data::Cmp::cmp_data           | simple scalar  |   1100000 |   0.00087 |     5300   | 4.7e-09 |      23 |
 +-------------------------------+----------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataComparisonModules::Compare --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::Compare       |      26   |                   20.3 |        1   | 3.9e-05 |      20 |
 | Test::Deep::NoTest  |      16   |                   10.3 |        1.6 | 2.8e-05 |      20 |
 | Data::Cmp           |       9.7 |                    4   |        2.6 | 4.5e-05 |      21 |
 | perl -e1 (baseline) |       5.7 |                    0   |        4.5 | 1.9e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataComparisonModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataComparisonModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataComparisonModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
