package Task::SDK::Perigrin;
use strict;
our $VERSION = '0.03';

1;    # Magic true value required at end of module
__END__

=head1 NAME

Task::SDK::Perigrin - A List of Modules I Use Constantly


=head1 VERSION

This document describes Task::SDK::Perigrin version 0.03


=head1 SYNOPSIS

    $> cpan Task::SDK::Perigrin

=head1 DESCRIPTION

This is a meta-package that gathers together what I find to be my standard
install.

=head1 DEPENDENCIES


=head2 Specific Modules

=over

=item local::lib

=item Task::Kensho

=back

=head2 Moose

=over

=item  Moose

=item  namespace::autoclean

=item  MooseX::GetOpt

=item  MooseX::SimpleConfig

=item  MooseX::AttributeHelpers

=item  MooseX::POE

=item  MooseX::Declare

=item  MooseX::Types

=item  MooseX::Types::Path::Class

=item  MooseX::LogDispatch

=item  MooseX::Workers

=item  MooseX::MetaDescription

=item  MooseX::Storage

=item  Task::Moose

=back

=head2  Module Development

=over

=item  Module::Install

=item  Module::Install::AutoManifest

=item  Module::Install::Repository

=back

=head2  Bots

=over

=item  Task::POE::IRC

=item  Regexp::Common::IRC

=back

=head2 Storage

=over

=item  KiokuDB

=item  DBIx::Class

=back

=head2 Tools

=over

=item  App::Ack

=item  App::Nopaste

=item  Module::Corelist

=back

=head2 Utilities

=over

=item  JSON::Any

=item  YAML::XS

=back

=head2 Web

=over

=item  Catalyst::Runtime

=item  Catalyst::View::TT

=item  Catalyst::Controller::REST

=item  Catalyst::Authentication::Credential::OpenID

=item  HTTP::Engine

=back

=head2 XML

=over

=item  XML::LibXML

=item  XML::Toolkit

=back


=head1 BUGS AND LIMITATIONS

Please report any bugs or feature requests to
C<chris@prather.org>, or through the web interface at
L<http://rt.cpan.org>.

=head1 AUTHOR

Chris Prather  C<< <chris@prahter.org> >>

=head1 LICENCE AND COPYRIGHT

Copyright (c) 2007, Chris Prather C<< <chris@prahter.org> >>. Some rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
