use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::More;

run_in_tempdir {

    bif(qw/init/);

    isa_ok bif(qw/upgrade/), 'Bif::OK::Upgrade';

    # Empty repo
    isa_ok bif(qw/upgrade --force/), 'Bif::OK::ForceUpgrade';

    # Give the upgrade something to change. TODO: much, much more
    # work_deltas
    bif(qw/work 1 --at 00:00/);
    bif(qw/work - --at 01:00/);

    # work_buffers
    bif(qw/work 1 --at 02:00/);

    isa_ok bif(qw/upgrade --force/), 'Bif::OK::ForceUpgrade';

    # TODO keep old bif repositories around to run upgrades on
};

done_testing();
