CREATE TABLE hub_entities(
    hub_id INTEGER NOT NULL,
    entity_id INTEGER NOT NULL,
    PRIMARY KEY(hub_id,entity_id) ON CONFLICT IGNORE,
    FOREIGN KEY(hub_id) REFERENCES hubs(id) ON DELETE CASCADE,
    FOREIGN KEY(entity_id) REFERENCES entities(id) ON DELETE CASCADE
) WITHOUT ROWID;


CREATE TRIGGER
    hub_entities_ai_1
AFTER INSERT ON
    hub_entities
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.hub_id,
        NEW.entity_id
    );


    INSERT INTO -- OR IGNORE INTO
        hub_related_changes(
            hub_id,
            prefix,
            change_id,
            sha1
        )
    SELECT DISTINCT
        NEW.hub_id,
        SUBSTR(c.uuid, 1, 1),
        c.id,
        c.uuid
    FROM
        nodes_tree nt
    INNER JOIN
        nodes n
    ON
        n.id = nt.child
    INNER JOIN
        changes_tree ct
    ON
        ct.parent = n.first_change_id
    INNER JOIN
        changes c
    ON
        c.id = ct.child
    WHERE
        nt.parent = NEW.entity_id
    ;


    -- Remove this entity from associated project-related-changes
    -- TODO: something is reinserting these rows later on!
    DELETE FROM
        project_entities
    WHERE
        entity_id = NEW.entity_id AND project_id IN (
            SELECT
                ph.project_id
            FROM
                project_hubs ph
            WHERE
                ph.hub_id = NEW.hub_id
        )
    ;

END;


CREATE TRIGGER
    hub_entities_ad_1
AFTER DELETE ON
    hub_entities
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.hub_id,
        OLD.entity_id
    );


    DELETE FROM
        hub_related_changes
    WHERE
        hub_id = OLD.hub_id AND change_id IN (
            SELECT DISTINCT
                ct.child
            FROM
                nodes_tree nt
            INNER JOIN
                nodes n
            ON
                n.id = nt.child
            INNER JOIN
                changes_tree ct
            ON
                ct.parent = n.first_change_id
            WHERE
                nt.parent = OLD.entity_id
        )
    ;

END;
