package App::bif::show::version;
use strict;
use warnings;
use App::bif::Build;
use Bif::Mo;
use Config;
use Path::Tiny;

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;

    # Taken directly from perlvar(1)
    my $this_perl = $^X;
    if ( $^O ne 'VMS' ) {
        $this_perl .= $Config{_exe}
          unless $this_perl =~ m/$Config{_exe}$/i;
    }

    my ( $bold, $reset ) = $self->colours( 'bold', 'reset' );

    my @data = (
        [ $bold . 'Host' . $reset, '' ],
        [ 'archname:',             $Config{archname} ],
        [ 'osname:',               $Config{osname} ],
        [
            'perl:',
            sprintf( '%s (%d.%d.%d)',
                $this_perl,           $Config{api_revision},
                $Config{api_version}, $Config{api_subversion} )
        ],
        [ '-',                             '' ],
        [ $bold . 'Software' . $reset,     '' ],
        [ 'built:',                        $App::bif::Build::DATE ],
        [ 'commit:',                       $App::bif::Build::COMMIT ],
        [ 'version:',                      $App::bif::Build::VERSION ],
        [ '-',                             '' ],
        [ $bold . 'Installation' . $reset, '' ],
        [ 'bin:',                          path($0)->absolute ]
    );

    push( @data, [ 'lib:', path($App::bif::Build::FILE)->parent(3) ] )
      unless defined &static::find;

    my $repo      = eval { $self->repo };
    my $user_repo = eval { $self->user_repo };

    if ( $repo or $user_repo ) {
        push( @data,
            [ '-',                             '' ],
            [ $bold . 'Repositories' . $reset, '' ],
            [ 'current:',                      $repo ? $repo : '(not found)' ],
            [ 'user:', $user_repo ? $user_repo : '(not found)' ],
        );
    }

    print $self->render_table( ' l  l ', undef, \@data );

    return $self->ok('ShowVersion');
}

1;
__END__

=head1 NAME

=for bif-doc #show

bif-show-version - display bif version information

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif show version [OPTIONS...]

=head1 DESCRIPTION

The B<bif-show-version> command displays bif version and build
information.

=head1 SEE ALSO

L<bif>(1), L<App::bif::Build>

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

