package App::bif::new;
use strict;
use warnings;
use Bif::Mo;
use IO::Prompt::Tiny qw/prompt/;
use OptArgs qw/class_optargs/;

our $VERSION = '0.1.5_7';
extends 'App::bif';

# Run the real new-topic
sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $type = shift @{ $opts->{type} };

    my ( $class, $newopts ) = class_optargs(
        'App::bif',
        'new', 'topic', $type,
        @{ $opts->{type} },
        {
            $opts->{message}     ? ( message => $opts->{message} ) : (),
            $opts->{status}      ? ( status  => $opts->{status} )  : (),
            exists $opts->{bill} ? ( bill    => $opts->{bill} )    : (),
        },
    );

    return $self->dispatch( $class, opts => $newopts );

}

1;
__END__

=head1 NAME

=for bif-doc #create

bif-new - add a new topic to a project

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif new TYPE [TITLE...] [OPTIONS...]

=head1 DESCRIPTION

B<bif-new> is a fallback command for when none of the C<bif-new-*>
commands apply. It simply passes on the appropriate arguments and
options onto L<bif-new-topic>. For example:

    # This:
    bif new task Title -m Message

    # is equivalent to:
    bif new topic task Title -m Message

=head1 ARGUMENTS

=over

=item TYPE

The type of topic to create.

=item TITLE

The summary of this topic. Prompted for if not provided.

=back

=head1 OPTIONS

=over

=item --type, -t TYPE

The type of topic. Typically this is 'task' or 'issue', or 'bug', etc.
Defaults to 'topic'.

=item --status, -s STATE

The initial status of the topic. This must be a valid status for the
project as output by the L<bif-list-status>(1) command. A default is
used if not provided.

=item --message, -m MESSAGE

The body of the topic. An editor will be invoked if not provided.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

