package App::bif::check;
use strict;
use warnings;
use parent 'App::bif';

our $VERSION = '0.1.5_7';

# TODO Work out how to yamlcheck utf8 chars

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;

    my $errors = $db->xarrayrefs( pragma => 'foreign_key_check' );

    return $self->err(
        'FK',
        "Foreign Key errors!\n"
          . $self->render_table(
            ' l  r  l  r ',
            [ 'Table', 'ID', 'Destination', 'FKIndex' ], $errors
          )
    ) if $errors;

    my $sth = $db->xprepare(
        select   => 'c.id',
        from     => 'changes c',
        order_by => 'c.id ASC',
    );
    $sth->execute;

    my $bad = 0;

    while ( my $id = $sth->val ) {
        my ( $ok, $str ) = $self->check($id);
        if ($ok) {
            $self->lprint($str);
        }
        else {
            $bad++;
            $self->lprint( $str . "\n" );
        }
    }

    $self->lprint('');
    return $self->err( 'Check', "UUID mismatch errors: $bad" ) if $bad > 0;
    $self->lprint("Consistency/UUID check ok\n");
    return $self->ok('Check');
}

1;
__END__

=head1 NAME

=for bif-doc #devadmin

bif-check - check all changeset UUIDs

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif check [OPTIONS...]

=head1 DESCRIPTION

The B<bif-check> command reports on the differences between the YAML
created by various ON INSERT triggers, and the YAML/structure generated
by the C<changeset()> method of Bif::DBW::st.

This is a mostly a tool for developers.

=head1 ARGUMENTS & OPTIONS

=over

=item --verbose, -v

Display a diff of the changes.yaml value and the expected YAML text.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2014-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

