#!/usr/bin/perl -w

use strict;
use ExtUtils::Embed;

my $debug = 0;

print "Writing Makefile for the embed program\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

my $exe = $Config{_exe};
my $o = $Config{_o};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld};
my $cc = $Config{cc};
my $f2c = "../scripts/file2c.pl";

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv );

my $is_MSVC = $cc =~ m/^cl/;
if( $is_MSVC ) {
  $out = '-out:';
  $ccdebug = $debug ? '-Zi ' : '';
  $lddebug = $debug ? '-debug ' : '-release ';
  $warn = '-W3';
} else {
  $out = '-o ';
  $ccdebug = $debug ? '-g ' : '';
  $lddebug = $debug ? '' : '-s ';
  $warn = '-Wall -Wno-comments ';
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$^X
LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags

OBJECTS=main$o my_arch$o my_loader_tie$o my_loader_perlio$o my_loader$o

.c$o:
	\$(CC) -c \$(CFLAGS) \$<

all: embed$exe

clean:
	-\$(RM) my_loader_tie_pl.c my_loader_perlio_pl.c my_Dyna_pm.c
	-\$(RM) *$o
	-\$(RM) *.opt *.pdb
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) embed$exe
	-\$(RM) Makefile Makefile.old

embed$exe: \$(OBJECTS)
	\$(LD) \$(OBJECTS) \$(LDFLAGS) $out\$@

my_loader_tie_pl.c: my_loader_tie.pl $f2c
	\$(PERL) $f2c my_loader_tie.pl \$@ load_me

my_loader_perlio_pl.c: my_loader_perlio.pl $f2c
	\$(PERL) $f2c my_loader_perlio.pl \$@ load_me

my_Dyna_pm.c: my_Dyna.pm $f2c
	\$(PERL) $f2c my_Dyna.pm my_Dyna_pm.c load_me_2

main$o: main.c my_loader.h
my_arch$o: my_arch.c my_arch.h
my_loader$o: my_loader.c my_loader_priv.h my_Dyna_pm.c
my_loader_tie$o: my_loader_tie.c my_loader.h my_loader_tie_pl.c
my_loader_perlio$o: my_loader_perlio.c my_loader.h my_loader_perlio_pl.c

.SUFFIXES: $o

EOT

# local variables:
# mode: cperl
# end:
