# Copyrights 2006-2007 by Mark Overmeer.
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 1.02.

use warnings;
use strict;

package XML::Compile::Schema::Specs;
use vars '$VERSION';
$VERSION = '0.56';

use Log::Report 'xml-compile', syntax => 'SHORT';

use XML::Compile::Schema::BuiltInTypes   qw/%builtin_types/;


### Who will extend this?
# everything which is not caught by a special will need to pass through
# the official meta-scheme: the scheme of the scheme.  These lists are
# used to restrict the namespace to the specified, hiding all helper
# types.

my @builtin_common = qw/
 boolean
 byte
 date
 decimal
 double
 duration
 ENTITIES
 ENTITY
 float
 ID
 IDREF
 IDREFS
 int
 integer
 language
 long
 Name
 NCName
 negativeInteger
 NMTOKEN
 NMTOKENS
 nonNegativeInteger
 nonPositiveInteger
 NOTATION
 positiveInteger
 QName
 short
 string
 time
 token
 unsignedByte
 unsignedInt
 unsignedLong
 unsignedShort
 yearMonthDuration
 /;

my @builtin_extra_1999 = qw/
 binary
 recurringDate
 recurringDay
 recurringDuration
 timeDuration
 timeInstant
 timePeriod
 uriReference
 year
 /;

my @builtin_extra_2000 = (@builtin_extra_1999, qw/
 anyType
 CDATA
 / );

my @builtin_extra_2001  = qw/
 anySimpleType
 anyType
 anyURI
 base64binary
 dateTime
 dayTimeDuration
 gDay
 gMonth
 gMonthDay
 gYear
 gYearMonth
 hexBinary
 normalizedString
 precissionDecimal
 /;

my %builtin_public_1999 = map { ($_ => $_) }
   @builtin_common, @builtin_extra_1999;

my %builtin_public_2000 = map { ($_ => $_) }
   @builtin_common, @builtin_extra_2000;

my %builtin_public_2001 = map { ($_ => $_) }
   @builtin_common, @builtin_extra_2001;

my %sloppy_int_version =
 ( decimal            => 'double'
 , integer            => 'int'
 , long               => 'int'
 , nonNegativeInteger => 'unsigned_int'
 , nonPositiveInteger => 'non_pos_int'
 , positiveInteger    => 'positive_int'
 , negativeInteger    => 'negative_int'
 , unsignedLong       => 'unsigned_int'
 , unsignedInt        => 'unsigned_int'
 );

my %schema_1999 =
 ( uri_xsd => 'http://www.w3.org/1999/XMLSchema'
 , uri_xsi => 'http://www.w3.org/1999/XMLSchema-instance'

 , builtin_public => \%builtin_public_1999
 );

my %schema_2000 =
 ( uri_xsd => 'http://www.w3.org/2000/10/XMLSchema'
 , uri_xsi => 'http://www.w3.org/2000/10/XMLSchema-instance'

 , builtin_public => \%builtin_public_2000
 );

my %schema_2001 =
 ( uri_xsd  => 'http://www.w3.org/2001/XMLSchema'
 , uri_xsi  => 'http://www.w3.org/2001/XMLSchema-instance'

 , builtin_public => \%builtin_public_2001
 );

my %schemas = map { ($_->{uri_xsd} => $_) }
 \%schema_1999, \%schema_2000, \%schema_2001;


sub predefinedSchemas() { keys %schemas }


sub predefinedSchema($) { defined $_[1] ? $schemas{$_[1]} : () }


sub builtInType($$;$@)
{   my ($class, $node, $ns) = (shift, shift, shift);
    my $name = @_ % 1 ? shift : undef;
    unless(defined $name)
    {   if($ns =~ m/^\s*\{(.*)\}(.*)/ ) { ($ns, $name) = ($1, $2) }
        else
        {   error __x"incomplete type {namespace}"
                , namespace => $ns;
        }
    }

    my $schema = $schemas{$ns}
        or return ();

    my %args = @_;

    return $builtin_types{$sloppy_int_version{$name}}
        if $args{sloppy_integers} && exists $sloppy_int_version{$name};

    # only official names are exported this way
    my $public = $schema->{builtin_public}{$name};
    defined $public ? $builtin_types{$public} : ();
}

1;
