unit class LZW::Revolunet;

has Int $!dictsize = 57344;

method set_dictsize( Int $dsz ) returns Int {
    $!dictsize = $dsz if $dsz;
}

method get_dictsize returns Int {
    $!dictsize;
}

method encode_utf8( Str $s ) returns Str {
    my $_rs;
    if ( $s ) {
        $_rs = $s.encode.decode("windows-1252");
    }
    $_rs;
}

method decode_utf8( Str $s ) returns Str {
    my $_rs;
    if ( $s ) {
        $_rs = $s.encode("windows-1252").decode;
    }
    $_rs;
}

method compress( Str $s ) returns Str {
    my %dict;
    my @out;
    my $currChar;
    my UInt $i = 0;
    my @data   = ( $s  ).split(q{}, :skip-empty);
    my $phrase = @data[0];
    my $code   = $!dictsize;
    for (1..@data.elems-1) {
        $currChar = @data[$_];
        if ( %dict{ '_' ~ $phrase ~ $currChar }:exists ) {
            $phrase ~= $currChar;
        } else {
            @out.push(
                $phrase.chars > 1 ??
                %dict{ '_' ~ $phrase } !!
                ( $phrase.split(q{},:skip-empty) )[0].ord
            );
            %dict{ '_' ~ $phrase ~ $currChar } = $code;
            $code++;
            $phrase = $currChar;
        }
    }
    @out.push(
        $phrase.chars > 1 ??
        %dict{ '_' ~ $phrase } !!
        ( $phrase.split(q{},:skip-empty) )[0].ord
    );
    for @out -> $o {
        @out[$i] = $o.chr;
        $i++;
    }
    @out.join(q{});
}

method decompress( Str $s ) returns Str {
    my %dict;
    my @out;
    my $phrase;
    my UInt $i    = 0;
    my @data      = ( $s  ).split(q{}, :skip-empty);
    my $currChar  = @data[0];
    my $oldPhrase = $currChar;
    my $code   = $!dictsize;
    @out.push($currChar);
    for (1..@data.elems-1) {
        my $currCode = @data[$_].ord;
        if ( $currCode < $!dictsize ) {
            $phrase = @data[$_];
        } else {
            $phrase =
                %dict{ '_' ~ $currCode } ??
                %dict{ '_' ~ $currCode } !! ( $oldPhrase ~ $currChar );
        }
        @out.push($phrase);
        $currChar = ( $phrase.split(q{},:skip-empty) )[0];
        %dict{ '_' ~ $code } = $oldPhrase ~ $currChar;
        $code++;
        $oldPhrase = $phrase;
    }
    @out.join(q{});
}
