package Daje::Plugin::Base::Perl::Common;
use Mojo::Base -base, -signatures;

use Config::Tiny;
use Daje::Tools::Datasections;

has 'config';
has 'config_path';

sub _load_config ($self) {

    eval {
        $self->config(Config::Tiny->read($self->config_path()));
    };
    die "Could not load config '$@'" if $@;

    return;
}

sub _load_templates($self, $source, $data_sections) {
    my $template;
    eval {
        $template = Daje::Tools::Datasections->new(
            data_sections => $data_sections,
            source        => $source
        );
        $template->load_data_sections();
    };
    die "load_templates failed '$@'" if $@;

    return $template;
}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Plugin::Base::Common


=head1 REQUIRES

L<Daje::Tools::Datasections> 

L<Config::Tiny> 

L<Mojo::Base> 


=head1 METHODS


=cut

