class NESMusicAgent is MusicAgent
{	
	method BUILD($stat) {
		super.BUILD($stat);
	}

	method ask(%args) {
		my $string = super.ask(%args) . "ask music\n";
		
		return %string;
	}


	method ask_music_roms(%args) {
		my @roms;

		### if (%args{"ask music roms"}) {
		
			for %args.kv -> $key,$value {
				push(@roms, .musicdb.search($key));
			}
			return @roms;
		###}
		return <>;	
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process music or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask music roms" { self.ask(%optargs) }
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
