class NESROMAgent is Agent 
{
	has $.romdb;

	has $.machinecodedb;
	
	method BUILD($stat) {
		super.BUILD($stat);

		.romdb = new ROMDB();	
		.machinecodedb = new NESasmDB();
	}

	### add a key value pair such as "Dwarrendelf", "binary ROM file in a bytearray or something"
	method addToDB($key, value) {
		.romdb.add($key,$value);
	}

	method list_romdb_keys() {
		return .romdb.list_keys();	
	}

	method ask(%args) {
		my $string = super.ask(%args) . 
				"ask about roms\n" .
				"get roms\n" .
				"agent\n";
		
		return $string;
	}


	method ask_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {

			if (.romdb.search($key)) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .romdb.search($key));
		}
		return @roms;
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process roms or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask about roms" { self.ask_roms(%optargs) }
		when "get roms" { self.get_roms(%optargs) }
		when "list roms" { self.list_romdb_keys(%optargs) } 
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
