package Foo::Testmysqlorm::Sport;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';
use Foo::Testmysqlorm::Sport::ResultClass;

extends 'MySQL::ORM';

with 'Foo::Testmysqlorm::Sport::CustomRole';

has table_name => (
    is       => 'ro',
    isa      => 'Str',
    init_arg => undef,
    default  => 'sport',
);

method delete (
    Num|HashRef :$sport_id,
    Str|HashRef :$sport_name
) {
    my %a = @_;
    my %w;

    foreach my $arg ( keys %a ) {
        $w{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::delete(
        table => $self->table_name,
        where => \%w
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method get_id (
    Str|HashRef :$sport_name
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        $where{$arg} = $a{$arg};
    }

    my $rows = $self->SUPER::select(
        table => $self->table_name,
        where => \%where
    );

    if ( @$rows == 1 ) {
        my $row = shift @$rows;
        return $row->{league_id};
    }

    confess "too many rows returned" if @$rows > 1;

    return;
}

method insert (
    Str|HashRef :$sport_name
) {
    my %a = @_;
    my %v;

    foreach my $arg ( keys %a ) {
        $v{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::insert(
        table  => $self->table_name,
        values => \%v
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method is_primary_key_autoinc (
) {
    return 1;
}

method select (
    Num|HashRef :$sport_id,
    Str|HashRef :$sport_name,
    ArrayRef :$order_by
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        next if $arg eq 'order_by';
        $where{$arg} = $a{$arg};
    }

    my %s;
    $s{table}    = $self->table_name;
    $s{where}    = \%where;
    $s{order_by} = $order_by if $order_by;

    my $rows = $self->SUPER::select(%s);

    my @obj;
    foreach my $row (@$rows) {
        push @obj, Foo::Testmysqlorm::Sport::ResultClass->new(%$row);
    }

    return @obj;
}

method select_one (
    Num|HashRef :$sport_id,
    Str|HashRef :$sport_name
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        $where{$arg} = $a{$arg};
    }

    my $row = $self->SUPER::select_one(
        table => $self->table_name,
        where => \%where
    );
    if ($row) {
        return Foo::Testmysqlorm::Sport::ResultClass->new(%$row);
    }

    return;
}

method update (
    Foo::Testmysqlorm::Sport::ResultClass :$set,
    Num|HashRef :$sport_id,
    Str|HashRef :$sport_name
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        next if $arg eq 'set';
        $where{$arg} = $a{$arg};
    }

    my %values;
    my @attrs = $set->get_touched_attributes;
    foreach my $attr (@attrs) {
        $values{$attr} = $set->$attr;
    }

    my $ret = $self->SUPER::update(
        table  => $self->table_name,
        values => \%values,
        where  => \%where
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method upsert (
    Str|HashRef :$sport_name
) {
    my %a = @_;
    my %v;

    foreach my $arg ( keys %a ) {
        $v{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::upsert(
        table  => $self->table_name,
        values => \%v
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

1;
