# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 2496 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/static_hash.al)"
# ----------------------------------------------------------------------


sub static_hash {
  my ($class, @args) = @_;
  my %methods;

  foreach (@args) {
    my $field = $_;
    my %hash;

    $methods{$field} =
      sub {
        my ($class, @list) = @_;
        if (scalar @list == 1) {
          my ($key) = @list;

          if ( my $type = ref $key ) {
            if ( $type eq 'ARRAY' ) {
              return @hash{@$key};
            } elsif ( $type eq 'HASH' ) {
              while ( my ($subkey, $value) = each %$key ) {
                if ( $^W ) {
                  defined $value
                    or carp "No value for key $subkey of hash $field.";
                }
                $hash{$subkey} = $value;
              }
              return wantarray ? %hash : \%hash;
            } else {
              cluck "Not a recognized ref type for static hash: $type.";
            }
          } else {
            return $hash{$key};
          }
        } else {
          while (1) {
            my $key = shift @list;
            defined $key or last;
            my $value = shift @list;
            defined $value or carp "No value for key $key.";
            $hash{$key} = $value;
          }
          wantarray ? %hash : \%hash;
        }
      };

    $methods{$field . "_keys"} =
      sub {
        my ($class) = @_;
        keys %hash;
      };

    $methods{$field . "_values"} =
      sub {
        my ($class) = @_;
        values %hash;
      };

    $methods{$field . "_exists"} =
      sub {
        my ($class) = shift;
        my ($key) = @_;
        return
          exists $hash{$key};
      };

    $methods{$field . "_tally"} =
      sub {
        my ($class, @list) = @_;
        map { ++$hash{$_} } @list;
      };
  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::static_hash
1;
