use strict;
use warnings;

use Test::More;
use Path::Tiny;

my $tempdir = Path::Tiny->tempdir;
my ($hour,$mday,$mon,$year) = (localtime)[2..5];

my %params = (
    name      => 'file',
    min_level => 'debug',
    filename  => $tempdir->child('logfile.txt')->stringify,
);
my @tests = (
  { expected => $tempdir->child(sprintf("logfile-%04d%02d%02d.txt", $year+1900, $mon+1, $mday)),
    params   => {%params, 'binmode' => ':encoding(UTF-8)'},
    message  => "foo bar\x{20AC}",
    expected_message => "foo bar\xe2\x82\xac",
  },
);

use_ok('Log::Dispatch');
use_ok('Log::Dispatch::File::Stamped');

SKIP:
{
    skip "Cannot test utf8 files with this version of Perl ($])", 5 * @tests
        unless $] >= 5.008;

    for my $t (@tests) {
        my $dispatcher = Log::Dispatch->new;
        ok($dispatcher);
        my $file = $t->{expected};
        my $stamped = Log::Dispatch::File::Stamped->new(%{$t->{params}});
        ok($stamped);
        $dispatcher->add($stamped);
        $dispatcher->log( level   => 'info', message => $t->{message} );

        ok(-e $file, "$file exists");
        is($file->slurp, $t->{expected_message}, 'file contains correct (encoded) bytes');
    }
}

done_testing;
