#!/usr/bin/env perl
use strict;
use warnings;

use lib '../../lib';
use Net::DHCP::Packet;
use Net::Frame::Simple;
use Net::Frame::Dump::Offline;
use Data::Dumper;

#
# Simple offline anaysis
#
my $file = shift or die "Which file?\n";
my $oDump = Net::Frame::Dump::Offline->new(
    file => $file);

$oDump->start;

my $count = 0;
while (my $h = $oDump->next) {
  my $f = Net::Frame::Simple->new(
    raw        => $h->{raw},
    firstLayer => $h->{firstLayer},
    timestamp  => $h->{timestamp},
  );
  $f->unpack;

  my $len = length($h->{raw});
  print 'o Frame number: '.$count++." (length: $len)\n";
#  print $f->print."\n";
  print Net::DHCP::Packet->new($f->ref->{UDP}->payload)->toString;

}

$oDump->stop;

