## $Id: Object.pir 28197 2008-06-09 07:46:31Z tene $

=head1 TITLE

Object - Cardinal Object class

=head1 DESCRIPTION

This file sets up the base classes and methods for Cardinal's
object system.  Differences (and conflicts) between Parrot's
object model and the Cardinal model means we have to do a little
name and method trickery here and there, and this file takes
care of much of that.

Still heavily based off of Perl 6's.

=head2 Functions

=over

=item onload()

Perform initializations and create the base classes.

=cut

.namespace ['CardinalObject']

.sub 'onload' :anon :init :load
    .local pmc cardinalmeta
    load_bytecode 'P6object.pbc'
    $P0 = get_hll_global 'P6metaclass'
    $P0.'new_class'('CardinalObject', 'attr'=>'%!properties')
    cardinalmeta = $P0.'HOW'()
    set_hll_global ['CardinalObject'], '!CARDINALMETA', cardinalmeta
.end


=item !keyword_class(name)

Internal helper method to create a class.

=cut

.sub '!keyword_class' :method
    .param string name
    .local pmc class, resolve_list, methods, iter

    # Create class.
    class = newclass name

    # Set resolve list to include all methods of the class.
    methods = inspect class, 'methods'
    iter = new 'Iterator', methods
    resolve_list = new 'ResizableStringCardinalArray'
resolve_loop:
    unless iter goto resolve_loop_end
    $P0 = shift iter
    push resolve_list, $P0
    goto resolve_loop
resolve_loop_end:
    class.resolve_method(resolve_list)

    .return(class)
.end

=item !keyword_role(name)

Internal helper method to create a role.

=cut

.sub '!keyword_role' :method
    .param string name
    .local pmc info, role

    # Need to make sure it ends up attached to the right
    # namespace.
    info = new 'Hash'
    info['name'] = name
    $P0 = new 'ResizablePMCCardinalArray'
    $P0[0] = name
    info['namespace'] = $P0

    # Create role.
    role = new 'Role', info

    # Stash in namespace.
    $P0 = new 'ResizableStringCardinalArray'
    set_hll_global $P0, name, role

    .return(role)
.end

=item !keyword_does(class, role_name)

Internal helper method to implement the functionality of the does keyword.

=cut

.sub '!keyword_does' :method
    .param pmc class
    .param string role_name
    .local pmc role
    role = get_hll_global role_name
    addrole class, role
.end

=item !keyword_has(class, attr_name)

Adds an attribute with the given name to the class.

=cut

.sub '!keyword_has' :method
    .param pmc class
    .param string attr_name
    addattribute class, attr_name
.end

=back

=head2 Object methods

=over

=item new()

Create a new object having the same class as the invocant.

=cut

.sub 'new' :method
    .param pmc args :slurpy
    .param pmc named_args    :named :slurpy

    # Instantiate.
    .local pmc cardinalmeta
    cardinalmeta = get_hll_global ['CardinalObject'], '!CARDINALMETA'
    $P0 = cardinalmeta.get_parrotclass(self)
    $P1 = $P0.'new'()
    $P2 = $P1.'initialize'(args :flat, named_args :named :flat)

    .return ($P1)
.end

=item WHENCE()

Return the invocant's auto-vivification closure.

=cut

.sub 'WHENCE' :method
    $P0 = self.'WHAT'()
    $P1 = $P0.'WHENCE'()
    .return ($P1)
.end

=item REJECTS(topic)

Define REJECTS methods for objects (this would normally
be part of the Pattern role, but we put it here for now
until we get roles).

=cut

.sub 'REJECTS' :method
    .param pmc topic
    $P0 = self.'ACCEPTS'(topic)
    n_not $P0, $P0
    .return ($P0)
.end

=item true()

Defines the .true method on all objects via C<prefix:?>.

=cut

.sub 'true' :method
 .return 'prefix:?'(self)
.end

=item print()

=item say()

Print the object

=cut

.sub 'print' :method
    $P0 = get_hll_global 'print'
    .return $P0(self)
.end

.sub 'puts' :method
    $P0 = get_hll_global 'puts'
    .return $P0(self)
.end

=item to_s()

Return a CardinalString representation of the object.

=cut

.sub 'to_s' :method
    $P0 = new 'CardinalString'
    $P0 = self
    .return ($P0)
.end

.sub 'puts' :method
    $P0 = get_hll_global 'puts'
    .return $P0(self)
.end

=item methods()

Get a list of all methods in the object.

=cut

.include 'library/dumper.pir'
.sub 'methods' :method
    $P0 = class self
    $P1 = $P0.methods()
    .local pmc meth_iter
    meth_iter = new 'Iterator', $P1
    .local pmc method_list
    method_list = new 'CardinalArray'
  methods_loop:
    unless meth_iter goto methods_loop_end
    $P0 = shift meth_iter
    method_list.push($P0)
    goto methods_loop
  methods_loop_end:
    .return(method_list)
.end

=back

=cut

# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
