# Generated by default/object.tt
package Paws::ES::AutoTune;
  use Moose;
  has AutoTuneDetails => (is => 'ro', isa => 'Paws::ES::AutoTuneDetails');
  has AutoTuneType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::AutoTune

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::AutoTune object:

  $service_obj->Method(Att1 => { AutoTuneDetails => $value, ..., AutoTuneType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::AutoTune object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoTuneDetails

=head1 DESCRIPTION

Specifies Auto-Tune type and Auto-Tune action details.

=head1 ATTRIBUTES


=head2 AutoTuneDetails => L<Paws::ES::AutoTuneDetails>

Specifies details of the Auto-Tune action. See the Developer Guide
(https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
for more information.


=head2 AutoTuneType => Str

Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

