#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

สตาร์คราฟต์ เป็นวิดีโอเกมประเภทวางแผนเรียลไทม์และบันเทิงคดีวิทยาศาสตร์การทหาร พัฒนาและจัดจำหน่ายโดยบลิซซาร์ด เอ็นเตอร์เทนเมนต์ ออกบนระบบปฏิบัติการไมโครซอฟท์ วินโดวส์เมื่อวันที่ 31 มีนาคม 2541 ต่อมา เกมขยายเป็นแฟรนไชส์ และเป็นเกมแรกของซีรีส์สตาร์คราฟต์ รุ่นแมคโอเอสออกในเดือนมีนาคม 2542 และรุ่นดัดแปลงนินเทนโด 64 ซึ่งพัฒนาร่วมกับแมสมีเดีย ออกในวันที่ 13 มิถุนายน 2543 การพัฒนาเกมนี้เริ่มขึ้นไม่นานหลังวอร์คราฟต์ 2: ไทด์สออฟดาร์กเนส ออกในปี 2538 สตาร์คราฟต์เปิดตัวในงานอี3 ปี 2539 ซึ่งเป็นที่ชื่นชอบน้อยกว่าวอร์คราฟต์ 2 ฉะนั้น โครงการจึงถูกพลิกโฉมทั้งหมดแล้วแสดงต่อสาธารณะในต้นปี 2540 ซึ่งได้รับการตอบรับดีกว่ามาก
เกมมีฉากท้องเรื่องในเส้นเวลาสมมติระหว่างคริสต์ศตวรรษที่ 25 ของโลก โดยมุ่งไปยังสามสปีชีส์ที่แก่งแย่งชิงความเป็นใหญ่ในส่วนห่างไกลของดาราจักรทางช้างเผือก ซึ่งเรียก ภาคคอปรูลู สามสปีชีส์นั้นได้แก่ เทอร์แรน มนุษย์ซึ่งถูกเนรเทศจากโลก และมีทักษะการปรับตัวเข้ากับทุกสถานการณ์, เซิร์ก เผ่าพันธุ์คล้ายแมลงต่างดาวที่แสวงความสมบูรณ์ของพันธุกรรม และหมกมุ่นกับการกลืนกินเผ่าพันธุ์อื่น และโพรทอส เผ่าพันธุ์คล้ายมนุษย์ซึ่งมีเทคโนโลยีล้ำหน้าและความสามารถพลังจิต โดยพยายามรักษาอารยธรรมของพวกตนและวิถีชีวิตปรัชญาเคร่งครัดจากพวกเซิร์ก (อ่านต่อ...)

บทความคัดสรรก่อนหน้านี้: สงครามพระเจ้าตะเบ็งชเวตี้ – สมเด็จพระศรีพัชรินทราบรมราชินีนาถ พระบรมราชชนนีพันปีหลวง – กระจุกดาวทรงกลม

TEXT

#is(Text::Guess::Language->guess($text),'th','is th');

done_testing;
