#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/ScrolledWP.h>
#include <Xm/ArrowB.h>
#include <XmI/MacrosI.h>

Widget toplevel, sw, ab;
Dimension st;

void Doit(Widget w, XtPointer client, XtPointer call)
{
  XtVaGetValues(sw, XmNshadowThickness, &st, NULL);
  printf("ST: %d: CLIP GEO: %d %d %d %d\n",
	 st,
	 SW_ClipX(sw), SW_ClipY(sw), SW_ClipWidth(sw), SW_ClipHeight(sw));
  printf("HSB GEO: %d %d %d %d VSB GEO: %d %d %d %d\n",
	 SW_HSBX(sw), SW_HSBY(sw), SW_HSBWidth(sw), SW_HSBHeight(sw),
	 SW_VSBX(sw), SW_VSBY(sw), SW_VSBWidth(sw), SW_VSBHeight(sw));
}

int main(int argc, char **argv)
{
  XtAppContext app;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "Label", NULL, 0, &argc, argv, NULL, NULL);

  sw  = XtVaCreateManagedWidget("sw", xmScrolledWindowWidgetClass, toplevel, 
		XmNscrollingPolicy,	XmAUTOMATIC,
		XmNscrollBarPlacement,	XmBOTTOM_RIGHT,
		XmNwidth,		100,
		XmNheight,		100,
	NULL);

  ab = XtVaCreateManagedWidget("ab", xmArrowButtonWidgetClass, sw,
		XmNwidth,	300,
		XmNheight,	300,
	NULL);

  XtAddCallback(ab, XmNactivateCallback, Doit, NULL);

  XtRealizeWidget(toplevel);


  XtAppMainLoop(app);

  exit(0);
}
