/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <X11/Shell.h>
#include "viewer.h"
#include "net.h"


#define	MAXLEGEND	100


extern int NetGetListOfUsers();


extern Display *myDpy;
extern NetPort *outP;
extern Widget legendList;
extern char *UserID;


static char *legLabs[MAXLEGEND];
static int legendCount = 0;



void
InitLegend()
{
	XmString label;
	char *tlab;
	int indx;

	for (indx=0; indx<MAXLEGEND; indx++)
	{
		legLabs[indx] = NULL;
	}

	tlab = UserID;
	legLabs[0] = (char *)MALLOC(strlen(tlab) + 1);
	if (legLabs[0] == NULL)
	{
		fprintf(stderr, "Cannot malloc label space!\n");
		exit(1);
	}
	strcpy(legLabs[0], tlab);
	label = XmStringCreateSimple(legLabs[0]);
	XmListAddItem(legendList, label, 1);
	XmStringFree(label);

	legendCount = 1;
}


void
ClearLegend()
{
	int i;
	XmString label;

	for (i=0; i<legendCount; i++)
	{
		label = XmStringCreateSimple(legLabs[i]);
		XmListDeleteItem(legendList, label);
		XmStringFree(label);
		FREE((char *)legLabs[i]);
		legLabs[i] = NULL;
	}
	legendCount = 0;
}


void
NewLegend(indx, id)
	int indx;
	char *id;
{
	Cardinal i;
	Arg argList[10];
	XmString label;
	Pixel black;

	legLabs[indx] = (char *)MALLOC(strlen(id) + 1);
	if (legLabs[indx] == NULL)
	{
		fprintf(stderr, "Cannot malloc label space!\n");
		exit(1);
	}
	strcpy(legLabs[indx], id);

	label = XmStringCreateSimple(legLabs[indx]);
	XmListAddItem(legendList, label, (indx + 1));
	XmStringFree(label);

	legendCount++;
}


CheckLegend(id)
	char *id;
{
	int cnt;

	cnt = 0;
	while (cnt < legendCount)
	{
		if ((legLabs[cnt] == NULL)||(strcmp(legLabs[cnt], id) == 0))
		{
			break;
		}
		cnt++;
	}

	if ((cnt == legendCount)||(legLabs[cnt] == NULL))
	{
		if (cnt >= MAXLEGEND)
		{
			fprintf(stderr, "Error:  no room for more legends!\n");
			exit(1);
		}
		NewLegend(cnt, id);
		XFlush(myDpy);		/* EJB */
	}
}


void
DeleteLegend(id)
	char *id;
{
	int i, cnt;
	XmString label;

	cnt = 0;
	while (cnt < legendCount)
	{
		if ((legLabs[cnt] != NULL)&&(strcmp(legLabs[cnt], id) == 0))
		{
			break;
		}
		cnt++;
	}

	if (cnt != legendCount)
	{
		label = XmStringCreateSimple(legLabs[cnt]);
#ifdef DEBUG
	fprintf(stderr, "Deleteing %s from list\n", legLabs[cnt]);
#endif
		XmListDeleteItem(legendList, label);
		XmStringFree(label);
		FREE((char *)legLabs[cnt]);

		for (i = (cnt + 1); i < legendCount; i++)
		{
			legLabs[i - 1] = legLabs[i];
		}
		legendCount--;
		legLabs[legendCount] == NULL;

		XFlush(myDpy);		/* EJB */
	}
}


void
UpdateLegend()
{
	int i, cnt;
	char **users;

	users = (char **)MALLOC(MAXLEGEND * sizeof(char *));
	cnt = NetGetListOfUsers(MAXLEGEND, users);

	if (cnt == (legendCount - 1))
	{
		FREE((char *)users);
		return;
	}

	for (i = 0; i < cnt; i++)
	{
		CheckLegend(users[i]);
	}
	FREE((char *)users);
}


void
AddUser(user)
	char *user;
{
#ifdef DEBUG
	fprintf(stderr, "AddUser(%s)\n", user);
#endif
	CheckLegend(user);
}


void
RemoveUser(user)
	char *user;
{
#ifdef DEBUG
	fprintf(stderr, "RemoveUser(%s)\n", user);
#endif
	DeleteLegend(user);
}

