/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: grabras.c,v 1.3 1993/09/01 21:03:31 davet Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include "netdata.h"
#include "net.h"

/* #define DEF_CMAP	DefaultColormap(myDpy, DefaultScreen(myDpy)) */


#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif


extern void ConvertXColorsToRGB();
extern int NetSendDataObject();
extern void ScaleRasterImage();


extern XtAppContext app;
extern Display *myDpy;
extern GC invGC;
extern NetPort *outP;
extern char *UserID;

int grab_xstart, grab_xend;
int grab_ystart, grab_yend;

static int GrabCnt = 0;

XImage *
GrabImage(w, h)
	unsigned int *w, *h;
{
	int x, y;
	unsigned int width, height;
	XImage *cutbuffer;

	if (grab_xstart <= grab_xend)
	{
		x = grab_xstart;
		width = grab_xend - grab_xstart;
	}
	else
	{
		x = grab_xend;
		width = grab_xstart - grab_xend;
	}
	if (grab_ystart <= grab_yend)
	{
		y = grab_ystart;
		height = grab_yend - grab_ystart;
	}
	else
	{
		y = grab_yend;
		height = grab_ystart - grab_yend;
	}
	cutbuffer = XGetImage(myDpy, DefaultRootWindow(myDpy), x, y,
			      width, height, AllPlanes, ZPixmap);
	*w = width;
	*h = height;
	return(cutbuffer);
}


void
RootBox()
{
	int x, y;
	unsigned int width, height;

	if (grab_xstart <= grab_xend)
	{
		x = grab_xstart;
		width = grab_xend - grab_xstart;
	}
	else
	{
		x = grab_xend;
		width = grab_xstart - grab_xend;
	}
	if (grab_ystart <= grab_yend)
	{
		y = grab_ystart;
		height = grab_yend - grab_ystart;
	}
	else
	{
		y = grab_yend;
		height = grab_ystart - grab_yend;
	}
	XDrawRectangle(myDpy, DefaultRootWindow(myDpy), invGC, x, y,
		       width, height);
}



static XImage *
DoRasGrab(width, height)
	unsigned int *width, *height;
{
	int GrabState;
	XImage *cutbuffer;
	Cursor cursor;

	cursor = XCreateFontCursor(myDpy, XC_sizing);
	XSetSubwindowMode(myDpy, invGC, IncludeInferiors);

	if (XGrabPointer(myDpy, DefaultRootWindow(myDpy), False,
			 ButtonPressMask|ButtonReleaseMask|ButtonMotionMask,
			 GrabModeAsync, GrabModeAsync, None,
			 cursor, CurrentTime) != GrabSuccess)
	{
		fprintf (stderr, "Unable to grab pointer!\n");
		exit (1);
	}
	/*
	 * Unlike XGrabPointer, XGrabButton does not return a state of success
	 * or failure.  This means that is somone else has your screen grabbed
	 * doing a collage grab may have unpredictable results.
	 */
/*
	XGrabButton(myDpy, AnyButton, AnyModifier, inputWin,
		False, ButtonPressMask|ButtonReleaseMask|ButtonMotionMask,
		GrabModeAsync, GrabModeAsync, None,
		cursor);
*/

	/*
	 * Do the loop looking for a button press, drawing the image each time;
	 * since other clients may be running, make sure that the xor segments
	 * all get drawn at the same time.  
	 */
	GrabState = 0;
	while (GrabState != 2)
	{
		XEvent event;

		XtAppNextEvent(app, &event);
		switch (event.type)
		{
		      case ButtonPress:
			grab_xstart = event.xbutton.x_root;
			grab_ystart = event.xbutton.y_root;
			grab_xend = grab_xstart;
			grab_yend = grab_ystart;
			RootBox();
			GrabState = 1;
			break;
		      case MotionNotify:
			if (GrabState == 1)
			{
				RootBox();
				grab_xend =event.xbutton.x_root;
				grab_yend =event.xbutton.y_root;
				RootBox();
			}
			break;
		      case ButtonRelease:
			RootBox();
			GrabState = 2;
			break;
		      default:
			XtDispatchEvent(&event);
			continue;
		}	/* end switch */
	}	/* end while */
	XUngrabPointer(myDpy, CurrentTime);
	if (((grab_xstart - grab_xend) != 0)&&((grab_ystart - grab_yend) != 0))
	{
		cutbuffer = GrabImage(width, height);
	}
/*
	XUngrabButton(myDpy, AnyButton, AnyModifier, inputWin);
*/
	XSync(myDpy, False);
	XSetSubwindowMode(myDpy, invGC, ClipByChildren);
	return(cutbuffer);
}


void
CBGrabRasProc(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	XImage *cutbuffer;
	int i, j, junk;
	Colormap *cmaps;
	XColor ccells[256];
	unsigned int width, height;
	char label[500];
        unsigned long colr;
        char *id;
        char *ptr;
	Data *d;

	id = UserID;
	sprintf(label, "%s: Screen Grab %d", id, GrabCnt);
	GrabCnt++;

	d = DataNew();

	d->label = (char *)MALLOC(strlen(label) + 1);
	strcpy(d->label, label);

	width = height = 0;
	cutbuffer = DoRasGrab(&width, &height);

	if ((width == 0)||(height == 0))
	{
		GrabCnt--;
		return;
	}

	for (i=0; i<256; i++)
	{
		ccells[i].pixel = i;
	}
	cmaps = XListInstalledColormaps(myDpy, DefaultRootWindow(myDpy), &junk);
	/*
	 * No order is guaranteed in the colormaps returned by 
	 * XListInstalledColormaps(), however, there is no better way to
	 * find out which colormap is installed, especially if there are
	 * multiple hardware colormaps present, like on the SGIs.
	 * I have found that on one software colormap machines,
	 * XListInstalledColormaps() only returns one colormap, which is the
	 * one currently installed.  On SGIs it returns a long list of
	 * colormaps, and the last one in the list isn't always the
	 * currently installed one, but it is more often than the one
	 * returned by DefaultColormap(dsp, scr).  So I use this since
	 * it is better than nothing.
	 */
	XQueryColors(myDpy, cmaps[junk - 1], ccells, 256);
/*
	if (junk == 1)
	{
		XQueryColors(myDpy, cmaps[0], ccells, 256);
	}
	else
	{
		XQueryColors(myDpy, DEF_CMAP, ccells, 256);
	}
*/

        d->entity = ENT_Network;
	d->dot = DOT_Array;
	d->dost = DOST_Char;
	d->rank = 2;
	d->dim[0] = width;
	d->dim[1] = height;
	d->data = (char *)MALLOC(width * height);
	ptr = d->data;
	for (j=0; j<height; j++)
	{
		for (i=0; i<width; i++)
		{
			colr = XGetPixel(cutbuffer, i, j);
			*ptr = (unsigned char)colr;
			ptr++;
		}
	}

	d->group = DataNew();
	d->group->label = (char *)MALLOC(strlen(d->label) + 1);
	strcpy(d->group->label, d->label);
        d->group->entity = ENT_Network;
	d->group->dot = DOT_Palette8;
	d->group->dost = DOST_Char;
	d->group->rank = 1;
	d->group->dim[0] = 768;
	d->group->data = (char *)MALLOC(768);
	ConvertXColorsToRGB(ccells, (unsigned char *)d->group->data);
	d->group->group = NULL;

	ScaleRasterImage(d);
	(void)NetSendDataObject(0, d, FALSE, TRUE, "Grabber");
}
