/*
 * Copyright (c) 1992-93 by Mark Boyns (boyns@sdsu.edu)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#ifndef _rplay_h
#define _rplay_h

#define RPLAY_NULL	0
#define RPLAY_PLAY	1
#define RPLAY_STOP	2
#define RPLAY_PAUSE	3
#define RPLAY_CONTINUE	4
#define RPLAY_SOUND	5
#define RPLAY_VOLUME	6
#define RPLAY_NSOUNDS	7
#define RPLAY_COMMAND	8
#define RPLAY_APPEND	9
#define RPLAY_INSERT	10
#define RPLAY_DELETE	11
#define RPLAY_CHANGE	12

#define RPLAY_MIN_VOLUME	0
#define RPLAY_DEFAULT_VOLUME	127
#define RPLAY_MAX_VOLUME	255

/*
 * rplay errors used by rplay_errno
 */
#define RPLAY_ERROR_NONE	0
#define RPLAY_ERROR_MEMORY	1
#define RPLAY_ERROR_HOST	2
#define RPLAY_ERROR_CONNECT	3
#define RPLAY_ERROR_SOCKET	4
#define RPLAY_ERROR_WRITE	5
#define RPLAY_ERROR_CLOSE	6 
#define RPLAY_ERROR_PACKET_SIZE	7
#define RPLAY_ERROR_BROADCAST	8
#define RPLAY_ERROR_ATTRIBUTE	9
#define RPLAY_ERROR_COMMAND	10
#define RPLAY_ERROR_INDEX	11
#define RPLAY_ERROR_MODIFIER	12

/*
 * rplay2.0 support
 */
#define OLD_RPLAY_PLAY		1
#define OLD_RPLAY_STOP		2
#define OLD_RPLAY_PAUSE		3
#define OLD_RPLAY_CONTINUE	4

typedef struct _rplay_attrs
{
	struct _rplay_attrs	*next;
	char			*sound;
	int			volume;
} RPLAY_ATTRS;

typedef struct _rplay
{
	struct _rplay_attrs	*attrs;
	struct _rplay_attrs	**attrsp;
	char			*buf;
	int			len;
	int			size;
	int			command;
	int			nsounds;
} RPLAY;

extern int	rplay_errno;
extern char	*rplay_errlist[];

#ifdef __STDC__
RPLAY	*rplay_create(int);
char	*rplay_convert(char *);
int	rplay_pack(RPLAY *);
RPLAY	*rplay_unpack(char *);
void	rplay_destroy(RPLAY *);
int	rplay_open(char *);
int	rplay(int, RPLAY *);
int	rplay_close(int);
void	rplay_perror(char *);
#else
RPLAY	*rplay_create();
char	*rplay_convert();
int	rplay_pack();
RPLAY	*rplay_unpack();
void	rplay_destroy();
int	rplay_open();
int	rplay();
int	rplay_close();
void	rplay_perror();
#endif

#endif _rplay_h
