/*
 * Copyright (c) 1992-93 by Mark Boyns (boyns@sdsu.edu)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include "version.h"
#include "rplay.h"
#include <stdio.h>
#include <strings.h>

#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	int		rplay_fd, c, command, append_attr, volume, val; 
	char		*hosts, *p, *q;
	RPLAY		*rp;  
	extern char	*optarg; 
	extern int	optind;

	if (argc < 3)
	{
		usage();
	}

	hosts = argv[1];

	argc--;
	argv++; 

	command = RPLAY_PLAY;
	volume = RPLAY_DEFAULT_VOLUME;

	while ((c = getopt(argc, argv, "Vv:spch")) != -1)
	{
		switch(c) {
		case 'v':
			volume = atoi(optarg);
			break;

		case 's':   
			command = RPLAY_STOP;
			break;

		case 'p': 
			command = RPLAY_PAUSE;
			break;

		case 'c':  
			command = RPLAY_CONTINUE;
			break;
		
		case 'V':
			printf("rplay: %s\n", rplay_version);
			exit(0);

		case 'h':
		case '?':
			usage();
		} 
	}
		     
	if (optind == argc)
	{
		usage();
	} 
	
	rp = rplay_create(command);
	if (rp == NULL)
	{
		rplay_perror("rplay_create");
		exit(1);
	}
	  
	while (argv[optind] != NULL)
	{
		val = rplay_set(rp, RPLAY_APPEND,
			RPLAY_SOUND,	argv[optind++],
			RPLAY_VOLUME,	volume,
			NULL);
		if (val < 0)
		{
			rplay_perror("rplay_set");
			exit(1);
		}
	}

	q = hosts;
	do {
		p = q;
		q = index(p, ':');
		if (q != NULL)
		{
			*q++ = '\0';
		}
		rplay_fd = rplay_open(p);
		if (rplay_fd < 0)
		{
			rplay_perror(p);
			exit(1);
		}
		if (rplay(rplay_fd, rp) < 0)
		{
			rplay_perror(p);
			exit(1);
		}
		rplay_close(rplay_fd);
	} while (q != NULL);

	exit(0);
}

usage()
{
	printf("\n%s\n\n", rplay_version);
	printf("usage: rplay host[:host...] [options] sound ...\n");
	printf("\t-V\tprint rplay version and exit\n");
	printf("\t-h\tthis very helpful list\n");
	printf("\t-s\tstop\n");
	printf("\t-p\tpause\n");
	printf("\t-c\tcontinue\n");
	printf("\t-v n\tvolume n (%d <= n <= %d), default = %d\n",
		RPLAY_MIN_VOLUME,
		RPLAY_MAX_VOLUME,
		RPLAY_DEFAULT_VOLUME);
	printf("No options will play sound(s) at the default volume\n\n");
	exit(1);
}
